/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/level_history.hpp
 * \brief A class to manage undo/redo informations on a level.
 * \author Julien Jorge
 */
#ifndef __BF_LEVEL_HISTORY_HPP__
#define __BF_LEVEL_HISTORY_HPP__

#include "bf/level.hpp"

namespace bf
{
  /**
   * \brief A class to manage undo/redo informations on a level.
   * \author Julien Jorge
   */
  class level_history
  {
  public:
    level_history( level* lvl );
    ~level_history();

    bool can_undo() const;
    bool can_redo() const;

    void undo();
    void redo();

    void push();
    void push(level* lvl);

    void set_saved();
    bool saved_state() const;
    bool saved_state_in_past() const;
    bool saved_state_in_future() const;

    level& get_level();
    const level& get_level() const;

  private:
    void clear_past();
    void clear_future();

  private:
    /** \brief The level on which we are working. */
    level* m_level;

    /** \brief The previous states of the level. */
    std::list<level*> m_past;

    /** \brief The future states of the level. */
    std::list<level*> m_future;

    /** \brief The last instance of level that was saved. */
    level* m_last_saved_level;

    /** \brief Maximum size of the undo history. */
    std::size_t m_max_history;

  }; // class level_history
} // namespace bf

#endif // __BF_LEVEL_HISTORY_HPP__
