/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/image_pool.hpp
 * \brief A singleton containing all image resources.
 * \author Julien Jorge
 */
#ifndef __BF_IMAGE_POOL_HPP__
#define __BF_IMAGE_POOL_HPP__

#include <boost/filesystem/convenience.hpp>
#include <claw/basic_singleton.hpp>
#include <claw/iterator.hpp>
#include <claw/functional.hpp>
#include <map>

#include <wx/bitmap.h>
#include <wx/image.h>

namespace bf
{
  /**
   * \brief A singleton containing all image resources.
   * \author Julien Jorge
   */
  class image_pool
    : public claw::concept::basic_singleton<image_pool>
  {
  private:
    typedef std::map<wxString, wxBitmap> image_map;

  public:
    typedef claw::wrapped_iterator
    < const wxString,
      image_map::const_iterator,
      claw::const_pair_first<image_map::value_type> >
    ::iterator_type const_iterator;

  public:
    image_pool();

    void scan_directory( const std::string& dir_path );

    bool has_image( const wxString& image_name ) const;
    wxBitmap get_image( const wxString& image_name ) const;
    wxBitmap get_thumbnail( const wxString& image_name ) const;

    const_iterator begin() const;
    const_iterator end() const;

  private:
    void add_image( const std::string& root, const std::string& file_path );

    wxBitmap load_thumb( const std::string& path ) const;
    void load_image_data( const wxString& name );
    wxImage load_image( const std::string& path ) const;

    void scan_sub_directory
    ( const std::string& root, const boost::filesystem::path& dir );
    bool supported_extension( const std::string& path ) const;

  public:
    /** \brief The maximum size of the thumbnails. */
    static const wxSize s_thumb_size;

  private:
    /** \brief The item classes. */
    image_map m_image;

    /** \brief The thumbnails of the images. */
    image_map m_thumbnail;

    /** \brief The root directory where the images are searched. */
    wxString m_root;

  }; // class image_pool
} // namespace bf

#endif // __BF_IMAGE_POOL_HPP__
