/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file players_finish_level.hpp.hpp
 * \brief An item that changes the level when all players are colliding with it.
 * \author Sbastien Angibaud
 */
#ifndef __BEAR_PLAYERS_FINISH_LEVEL_HPP__
#define __BEAR_PLAYERS_FINISH_LEVEL_HPP__

#include "engine/base_item.hpp"
#include "engine/pointer_to_player.hpp"

namespace bear
{
  /**
   * \brief The class describing a object which start the next level
   * when all players are in collision.
   * \author Sbastien Angibaud
   * The custom fields of this class are :
   * - level : (string) The next level.
   */
  class players_finish_level : public engine::base_item
  {
  public:
    /** \brief The type of the parent class. */
    typedef engine::base_item super;

  public:
    players_finish_level();

    void start();
    void progress( universe::time_type elapsed_time );
    bool is_valid() const;
    bool set_string_field( const std::string& name, const std::string& value );

  private:
    /** \brief Pointer to the first player. */
    engine::pointer_to_player m_first_player;

    /** \brief Pointer to the second player. */
    engine::pointer_to_player m_second_player;

    /** \brief The name of the level to load. */
    std::string m_level_name;

  }; // class players_finish_level
} // namespace bear

#endif // __BEAR_PLAYERS_FINISH_LEVEL_HPP__
