/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file platform_with_two_elastics.hpp
 * \brief A platform linked to two items (one on the left, one on the right),
 *        with two elastics.
 * \author Julien Jorge
 */
#ifndef __BEAR_PLATFORM_WITH_TWO_ELASTICS_HPP__
#define __BEAR_PLATFORM_WITH_TWO_ELASTICS_HPP__

#include "engine/base_item.hpp"
#include "generic_items/falling_block.hpp"


namespace bear
{
  /**
   * \brief A platform linked to two items (one on the left, one on the right),
   *        with two elastics.
   * \author Julien Jorge
   */
  class platform_with_two_elastics :
    public engine::base_item
  {
  public:
    /** \brief The type of the parent class. */
    typedef engine::base_item super;

  public:
    platform_with_two_elastics();
    ~platform_with_two_elastics();

    bool set_real_field( const std::string& name, double value );
    bool set_u_integer_field( const std::string& name, unsigned int value );
    bool set_sprite_field( const std::string& name, visual::sprite* value );

    bool is_valid() const;

    void start();
    void get_visual( std::list<engine::scene_visual>& visuals ) const;

  private:
    void set_position();
    void create_links() const;

    void render_left_link( std::list<engine::scene_visual>& visuals ) const;
    void render_right_link( std::list<engine::scene_visual>& visuals ) const;

    void render_link( std::list<engine::scene_visual>& visuals,
                      const universe::position_type& src,
                      const universe::position_type& target ) const;

  private:
    /** \brief The sprite to use to draw the links. */
    visual::sprite* m_link_sprite;

    /** \brief The length of each link. */
    unsigned int m_link_length;

    /** \brief The strength of each link. */
    double m_link_strength;

    /** \brief The sprite to use for the platform. */
    visual::sprite* m_platform_sprite;

    /** \brief The platform. */
    falling_block* m_platform;

    /** \brief The number of times the link sprite must be drawn for a link. */
    unsigned int m_link_steps;

  }; // class platform_with_two_elastics
} // namespace bear

#endif // __BEAR_PLATFORM_WITH_TWO_ELASTICS_HPP__
