/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file pendulum.hpp
 * \brief An item balancing like a pendulum.
 * \author Julien Jorge
 */
#ifndef __BEAR_PENDULUM_HPP__
#define __BEAR_PENDULUM_HPP__

#include "engine/base_item.hpp"
#include "visual/sprite.hpp"

namespace bear
{
  /**
   * \brief An item balancing like a pendulum.
   * \author Julien Jorge
   */
  class pendulum : public engine::base_item
  {
  private:
    /** \brief The type of the parent class. */
    typedef engine::base_item super;

  public:
    pendulum();
    ~pendulum();

    void start();

    bool set_sprite_field( const std::string& name, visual::sprite* value );
    bool set_u_integer_field( const std::string& name, unsigned int value );
    bool set_real_field( const std::string& name, double value );

    bool is_valid() const;

    void progress( universe::time_type elapsed_time );
    void get_visual( std::list<engine::scene_visual>& visuals ) const;

  private:
    /** \brief The picture of the links. */
    visual::sprite* m_link;

    /** \brief Current step. */
    unsigned int m_step;

    /** \brief The number of links. */
    unsigned int m_length;

    /** \brief The speed of the movement. */
    unsigned int m_speed;

    /** \brief The vertical movement is this ratio of the height. */
    unsigned int m_vertical_ratio;

  }; // class pendulum
} // namespace bear

#endif // __BEAR_PENDULUM_HPP__
