/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file level_loader_item.hpp
 * \brief This item loads a level.
 * \author Julien Jorge
 */
#ifndef __BEAR_LEVEL_LOADER_ITEM_HPP__
#define __BEAR_LEVEL_LOADER_ITEM_HPP__

#include "engine/base_item.hpp"
#include "engine/level_loader.hpp"

namespace bear
{
  /**
   * \brief This item loads a level.
   *
   * The custom fields of this class are :
   * - delay : integer, number of milliseconds of delay,
   * - level : string, name of the level to start.
   *
   * \author Julien Jorge.
   */
  class level_loader_item:
    public bear::engine::base_item
  {
    typedef bear::engine::base_item super;

  public:
    level_loader_item();
    ~level_loader_item();

    void start();
    void progress( bear::universe::time_type elapsed_time );

    bool set_u_integer_field( const std::string& name, unsigned int value );
    bool set_string_field( const std::string& name, const std::string& value );

    bool is_valid();

  private:
    void progress_loading();

  private:
    /** \brief The loader with wich we load the level. */
    engine::level_loader* m_level_loader;

    /** \brief The file given to the level_loader. */
    engine::compiled_file* m_level_file;

    /** \brief The stream passed to the compiled file. */
    std::stringstream* m_level_stream;

    /** \brief The level, once we have loaded it. */
    engine::level* m_level;

    /** \brief The name of the level to load. */
    std::string m_level_name;

    /** \brief The time elapsed since the creation of the item. */
    universe::time_type m_time;

    /** \brief The delay before we start the next level. */
    universe::time_type m_delay;

  }; // class level_loader_item
} // namespace bear

#endif // __BEAR_LEVEL_LOADER_ITEM_HPP__
