/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file player_start_position.tpp
 * \brief Implementation of the bear::player_start_position class.
 * \author Julien Jorge
 */
#include "engine/game.hpp"
#include "engine/player.hpp"
#include "engine/world.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
template<class Player>
bear::player_start_position<Player>::player_start_position()
  : m_player_index(0)
{

} // player_start_position::player_start_position()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type <unsigned integer>.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
template<class Player>
bool bear::player_start_position<Player>::set_u_integer_field
( const std::string& name, unsigned int value )
{
  bool result;

  if ( name == "player_index" )
    {
      m_player_index = value;
      result = true;
    }
  else
    result = super::set_u_integer_field( name, value );

  return result;
} // player_start_position::set_u_integer_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Tell if the item is correctly initialized.
 */
template<class Player>
bool bear::player_start_position<Player>::is_valid() const
{
  /** \todo Test m_player_index is less or equal to the number of players. */
  return (m_player_index!=0) && engine::base_item::is_valid();
} // player_start_position::is_valid()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create the player and die.
 */
template<class Player>
void bear::player_start_position<Player>::start()
{
  CLAW_PRECOND( get_owner() != NULL );

  unsigned int players =
    engine::game::get_instance().get_const_rules().get_number_of_players();

  if ( players >= m_player_index)
    {
      engine::world* w = get_owner();
      engine::player* p = new Player;

      p->set_u_integer_field( "index", m_player_index );
      p->set_center_of_mass( get_center_of_mass() );

      w->register_item( p );

      p->start();
    }

  kill();
} // player_start_position::start()
