/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file base_visible_block.hpp
 * \brief A class representing a base of a visible block.
 *
 * The custom fields of this class are:
 *  - "sprite" : visual::sprite*, the sprite representing the block.
 *  - anything supported by the parent class
 *
 * \author Sebastien Angibaud
 */
#ifndef __BEAR_BASE_VISIBLE_BLOCK_HPP__
#define __BEAR_BASE_VISIBLE_BLOCK_HPP__

#include "engine/base_item.hpp"
#include "engine/item_with_decoration.hpp"
#include "generic_items/base_invisible_block.hpp"

namespace bear
{
  /**
   * \brief A class representing a base of a visible block.
   * \author Sebastien Angibaud
   */
  template<class EventGenerator>
  class base_visible_block:
    public engine::item_with_decoration
    < base_invisible_block< EventGenerator > >
  {

  }; // class base_visible_block
} // namespace bear

#endif // __BEAR_BASE_VISIBLE_BLOCK_HPP__
