/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file base_train.hpp
 * \brief The class describing the base of a train platform.
 * \author Sebastien Angibaud
 */
#ifndef __BEAR_BASE_TRAIN_HPP__
#define __BEAR_BASE_TRAIN_HPP__

#include "engine/item_with_decoration.hpp"
#include "generic_items/class_export.hpp"
#include "generic_items/invisible_block.hpp"
#include "universe/physical_item_state.hpp"
#include "universe/forced_train.hpp"

#include "time/time_reference.hpp"
#include <list>
#include <vector>

namespace bear
{
  /**
   * \brief The class describing a train platform.
   * \author Sebastien Angibaud
   */
  class GENERIC_ITEMS_EXPORT base_train:
    public engine::item_with_decoration<invisible_block>
  {
  public:
    /** \brief The type of the parent class. */
    typedef engine::item_with_decoration<invisible_block> super;

    /** \brief The type of the list in which we store the items depending on the
        train. */
    typedef std::list<engine::item_handle> item_list;

  public:
    base_train();
    ~base_train();

    void start();
    void progress( universe::time_type elapsed_time );

    bool set_u_integer_field( const std::string& name, unsigned int value );
    bool set_bool_field( const std::string& name, bool value );
    bool set_item_list_field
    ( const std::string& name, const std::vector<base_item*>& value);

    bool is_valid() const;

    virtual void set_top_contact(universe::physical_item_state& item);
    virtual void move( universe::time_type elapsed_time );
    virtual void get_dependent_items(std::set<physical_item_state*>& items_set);

  protected:
    void to_string( std::string& str ) const;

  private:
    void generate_forced_movement();

  protected:
    /** \brief The list of items on the platform. */
    item_list m_list_items;

    /** \brief The last position of the platform. */
    universe::position_type m_last_position;

    /** \brief the list of targets. They are not passed to the world. */
    std::vector<base_item*> m_targets;

    /** \brief Indicates the number of loops. */
    unsigned int m_loops;

    /** \brief Indicates if we come back on the targets. */
    bool m_loop_back;

  }; // class base_train
} // namespace bear

#endif // __BEAR_BASE_TRAIN_HPP__
