/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file screen.tpp
 * \brief Implementation of the template methods of the bear::visual::screen
 *        class.
 * \author Julien Jorge
 */

/*----------------------------------------------------------------------------*/
/**
 * \brief Draw a line.
 * \param color The color of the line.
 * \param first Iterator pointing on the first point.
 * \param last Iterator pointing just past the last point.
 * \param w The width of the line.
 *
 * \b Type \b requirements:
 *  - \a Iterator is a pointer to a structure containing at least two members
 *    \e x and \e y.
 */
#include <limits>
template<typename Iterator>
void bear::visual::screen::draw_line
( const claw::graphic::pixel32& color, Iterator first, Iterator last, double w )
{
  CLAW_PRECOND(m_mode == SCREEN_RENDER);

  glBindTexture( GL_TEXTURE_2D, 0 );
  glLineWidth(w);
  glEnable(GL_BLEND);

  glBegin(GL_LINE_STRIP);
  {
    const GLdouble max =
      std::numeric_limits<claw::graphic::pixel32::component_type>::max();

    glColor4f( (GLfloat)color.components.red / max,
	       (GLfloat)color.components.green / max,
	       (GLfloat)color.components.blue / max,
	       (GLfloat)color.components.alpha / max );

    for ( ; first!=last; ++first )
      glVertex2i( first->x, first->y );
  }
  glEnd();

  glDisable(GL_BLEND);

  failure_check( __FUNCTION__ );
} // screen::draw_line()
