/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file negative_effect.cpp
 * \brief Implementation of the bear::visual::negative_effect class.
 * \author Julien Jorge
 */
#include "visual/negative_effect.hpp"

/*---------------------------------------------------------------------------*/
/**
 * \brief Apply the effect to an image.
 * \param image The image to modify.
 */
void bear::visual::negative_effect::apply( claw::graphic::image& image )
{
  claw::graphic::image::iterator pixel = image.begin();
  const unsigned int borne = image.width() * image.height();

  for (unsigned int i=0; i!=borne; ++i, ++pixel)
    {
      pixel->pixel = ~pixel->pixel;
      pixel->components.alpha = ~pixel->components.alpha;
    }
} // negative_effect::apply()

