/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file grey_effect.cpp
 * \brief Implementation of the bear::visual::grey_effect class.
 * \author Julien Jorge
 */
#include "visual/grey_effect.hpp"

#include <cassert>

#define GL_GLEXT_PROTOTYPES
#include <GL/gl.h>
#include <GL/glext.h>

/*---------------------------------------------------------------------------*/
/**
 * \brief Trun an image into greyscale.
 */
void bear::visual::grey_effect::apply()
{
  std::string ext( (char*)glGetString( GL_EXTENSIONS ) );

  if ( ext.find("GL_ARB_fragment_program") == std::string::npos )
    std::cerr << "ERREUR" << std::endl;
  else
    {
      GLuint    g_pixelProgramID;

      glGenProgramsARB( 1, &g_pixelProgramID );
      glBindProgramARB( GL_FRAGMENT_PROGRAM_ARB, g_pixelProgramID );

      std::string prog =
        "PARAM c[1] = { program.local[0] };"
        "TEMP R0;"
        "ADD R0.x, fragment.color.primary, fragment.color.primary.y;"
        "ADD result.color.xyz, R0.x, fragment.color.primary.z;"
        "MOV result.color.w, fragment.color.primary;"
        "END";

      glProgramStringARB( GL_FRAGMENT_PROGRAM_ARB, GL_PROGRAM_FORMAT_ASCII_ARB,
                          prog.length(), prog.c_str() );
      assert( glGetError() == GL_NO_ERROR );
    }
} // grey_effect::apply()
