/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file rigid_link.cpp
 * \brief Implementation of the bear::universe::rigid_link class.
 * \author Julien Jorge
 */
#include "universe/link/rigid_link.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param first_item The first linked item.
 * \param second_item The second linked item.
 */
bear::universe::rigid_link::rigid_link
( physical_item& first_item, physical_item& second_item )
  : base_link(first_item, second_item),
    m_distance( second_item.get_position() - first_item.get_position() )
{

} // rigid_link::rigid_link()

/*----------------------------------------------------------------------------*/
/**
 * \brief Update the distance between the items.
 */
void bear::universe::rigid_link::adjust()
{
  m_second_item->set_position( m_first_item->get_position() + m_distance );
} // rigid_link::adjust()
