/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file forced_join.hpp
 * \brief A forced movement that will trie to bring an item to an other item.
 * \author Julien Jorge
 */
#ifndef __UNIVERSE_FORCED_JOIN_HPP__
#define __UNIVERSE_FORCED_JOIN_HPP__

#include "universe/forced_movement.hpp"

#include "universe/class_export.hpp"

namespace bear
{
  namespace universe
  {

    /**
     * \brief A forced movement that will trie to bring an item to an other
     *        item.
     * \author Julien Jorge
     */
    class UNIVERSE_EXPORT forced_join:
      public forced_movement
    {
    public:
      forced_join( physical_item& moving_item, const physical_item& target,
                   unsigned int steps );

      virtual void start();
      virtual void next_position();
      virtual void stop();

    private:
      /** \brief The item we're trying to reach. */
      const physical_item& m_target;

      /** \brief remaining steps to reach the target. */
      unsigned int m_remaining_steps;

      /** \brief True if the movement is currently playing. */
      bool m_playing;

    }; // class forced_join
  } // namespace universe
} // namespace bear

#endif // __UNIVERSE_FORCED_JOIN_HPP__
