/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file conditional_collision_event.hpp
 * \brief A collision event that activate an other collision event according to
 *        the result of a test on the items.
 * \author Julien Jorge
 */
#ifndef __UNIVERSE_CONDITIONAL_COLLISION_EVENT_HPP__
#define __UNIVERSE_CONDITIONAL_COLLISION_EVENT_HPP__

#include "universe/collision_event/collision_event.hpp"

namespace bear
{
  namespace universe
  {
    /**
     * \brief A collision event that activate an other collision event according
     *        to the result of a test on the items.
     *
     * \b Template \b parameters
     * - \a Test the test to verify to execute the \a Then collision event
     * - \a Then the collision event executed when \a Test is verified
     * - \a Else the collision event executed when \a Test is not verified
     *
     * \b Type \b requirements
     * - \a Test has a method with the followin signature:
     *   <tt>bool operator()( const collision_info& info, physical_item& self,
     *                        physical_item& that ) [const]; </tt>
     * - \a Then inherit from collision_event
     * - \a Else inherit from collision_event
     *
     * \author Julien Jorge
     */
    template<typename Test>
    class conditional_collision_event : public collision_event
    {
    public:
      typedef Test test_type;

    public:
      conditional_collision_event();
      conditional_collision_event
      ( test_type* test_condition,
        collision_event* then_clause = new collision_event(),
        collision_event* else_clause = new collision_event() );

      ~conditional_collision_event();

      void execute( const collision_info& info, physical_item& self,
                    physical_item& that ) const;

    private:
      /** \brief The test to verify to execute the then clause. */
      Test* m_test;

      /** \brief Collision event executed when the test is verified. */
      collision_event* m_then_clause;

      /** \brief Collision event executed when the test is not verified. */
      collision_event* m_else_clause;

    }; // class conditional_collision_event

  } // namespace universe
} // namespace bear

#include "universe/collision_event/code/conditional_collision_event.tpp"

#endif // __UNIVERSE_CONDITIONAL_COLLISION_EVENT_HPP__
