/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file collision_event_align.hpp
 * \brief Template class for alignments events for collisions.
 * \author Julien Jorge
 */
#ifndef __UNIVERSE_COLLISION_EVENT_ALIGN_HPP__
#define __UNIVERSE_COLLISION_EVENT_ALIGN_HPP__

#include "universe/collision_event/collision_event.hpp"
#include "universe/collision_event/define_align_event.hpp"
#include "universe/collision_event/align_event_generator.hpp"

namespace bear
{
  namespace universe
  {
    /**
     * \brief Template class for alignments events for collisions.
     */
    template<class Alignment>
    class collision_event_align : public collision_event
    {
    public:
      virtual void execute( const collision_info& info, physical_item& self,
                            physical_item& that ) const;

    }; // class collision_event_align

    // define the collision_event_align_type class
    DEFINE_ALIGN_EVENT_TYPE( collision_event_align );

    typedef
    align_event_generator<collision_event_align_type> event_generator_align;

  } // namespace universe
} // namespace bear

#include "universe/collision_event/code/collision_event_align.tpp"

#endif // __UNIVERSE_COLLISION_EVENT_ALIGN_HPP__
