/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file conditional_collision_event.cpp
 * \brief Implementation of the bear::universe::contitional_collision_event
 *         class.
 * \author Julien Jorge
 */

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
template<typename Test>
bear::universe::conditional_collision_event<Test>::
conditional_collision_event()
  : m_test( new test_type() ), m_then_clause( new collision_event() ),
    m_else_clause( new collision_event() )
{

} // conditional_collision_event::conditional_collision_event()

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param test_condition The object to use for the test.
 * \param then_clause The collision event to use for the then clause.
 * \param else_clause The collision event to use for the else clause.
 */
template<typename Test>
bear::universe::conditional_collision_event<Test>::conditional_collision_event
( test_type* test_condition, collision_event* then_clause,
  collision_event* else_clause )
  : m_test(test_condition), m_then_clause(then_clause),
    m_else_clause(else_clause)
{

} // conditional_collision_event::conditional_collision_event()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
template<typename Test>
bear::universe::conditional_collision_event<Test>::~conditional_collision_event
()
{
  delete m_test;
  delete m_then_clause;
  delete m_else_clause;
} // conditional_collision_event::~conditional_collision_event()

/*----------------------------------------------------------------------------*/
/**
 * \brief Execute a collision event according to the result of the test.
 * \param info Informations on the collision.
 * \param self The first item in the collision.
 * \param that The other item in the collision.
 */
template<typename Test>
void bear::universe::conditional_collision_event<Test>::execute
( const collision_info& info, physical_item& self, physical_item& that ) const
{
  if ( (*m_test)( info, self, that ) )
    m_then_clause->execute( info, self, that );
  else
    m_else_clause->execute( info, self, that );
} // conditional_collision_event::execute()
