/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file collision_event_align_stop.tpp
 * \brief Implementation of the bear::universe::collision_event_align_stop
 *        class.
 * \author Julien Jorge
 */

/*----------------------------------------------------------------------------*/
/**
 * \brief Align the other item and stop him horizontaly if he's on the left or
 *        on the right, or stop him verticaly if he's on the top or at the
 *        bottom.
 * \param info Informations on the collision.
 * \param self The first item in the collision.
 * \param that The item to align.
 */
template<class Alignment>
void bear::universe::collision_event_align_stop<Alignment>::execute
( const collision_info& info, physical_item& self, physical_item& that ) const
{
  super::execute( info, self, that );

  if ( !that.is_phantom() )
    {
      speed_type speed;
      force_type accel;

      speed = that.get_speed();
      accel = that.get_acceleration();

      switch( info.get_collision_side() )
        {
        case zone::bottom_zone:
          that.set_top_contact(that);
          self.set_bottom_contact(self);
          speed.y = accel.y = 0;
          break;
        case zone::top_zone:
          that.set_bottom_contact(self);
          self.set_top_contact(that);
          speed.y = accel.y = 0;
          break;
        case zone::middle_left_zone:
          that.set_right_contact(self);
          self.set_left_contact(that);
          speed.x = accel.x = 0;
          break;
        case zone::middle_right_zone:
          that.set_left_contact(self);
          self.set_right_contact(that);
          speed.x = accel.x = 0;
          break;
        default: { }
        }

      that.set_speed( speed );
      that.set_acceleration( accel );
    }
} // collision_event_align_stop::execute()
