/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file align_event_generator.hpp
 * \brief Event generator for collision events requiring a zone (typically
 *        alignments) and whose constructor doesn't have parameters.
 * \author Julien Jorge
 */
#ifndef __UNIVERSE_ALIGN_EVENT_GENERATOR_HPP__
#define __UNIVERSE_ALIGN_EVENT_GENERATOR_HPP__

#include "universe/collision_event/collision_event.hpp"
#include "universe/physical_item.hpp"

namespace bear
{
  namespace universe
  {
    /**
     * \brief Event generator for collision events requiring a zone (typically
     *        alignments) and whose constructors don't have parameters.
     * \author Julien Jorge
     */
    template<class Event>
    class align_event_generator
    {
    public:
      /**
       * \brief Instanciate the collision event corresponding to a zone.
       * \param self (not used) The physical item in which the event will be
       *        added.
       * \remark The \a self parameter is here to allow you to use collision
       *         events whose constructor's parameters list is not empty. It's
       *         set here so you can use the generator in a uniform way.
       */
      template<zone::position Z>
      collision_event* get( const physical_item& self ) const
      {
        return this->template get<Z>();
      }

      /**
       * \brief Instanciate the collision event corresponding to a zone.
       */
      template<zone::position Z>
      collision_event* get() const
      {
        return new typename Event::template type<Z>;
      }
    }; // class align_event_generator
  } // namespace universe
} // namespace bear

#endif // __UNIVERSE_ALIGN_EVENT_GENERATOR_HPP__
