/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file time_reference.cpp
 * \brief Implementation of the time::time_reference class.
 * \author Julien Jorge.
 */
#include "time/time_reference.hpp"

#include <cstddef>
#include <sys/time.h>

#ifdef _WIN32
#include <windows.h>
#endif

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the time value to the current time.
 */
void bear::time_ref::time_reference::set()
{
#ifdef _WIN32
  LARGE_INTEGER freq, c;

  QueryPerformanceFrequency(&freq);
  QueryPerformanceCounter(&c);

  m_milliseconds = (unsigned int)((c.QuadPart * 1000) / freq.QuadPart);
#else // _WIN32
  timeval tv;

  gettimeofday( &tv, NULL );

  m_milliseconds = tv.tv_sec * 1000 + tv.tv_usec / 1000;
#endif // _WIN32
} // time_reference::set()

/*----------------------------------------------------------------------------*/
/**
 * \brief Convert the time to an unsigned int.
 * \return The number of milliseconds.
 */
bear::time_ref::time_reference::operator unsigned int() const
{
  return m_milliseconds;
} // time_reference::operator unsigned int()

