/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file font.hpp
 * \brief A class representing a font.
 * \author Sebastien Angibaud
 */
#ifndef __TEXT_FONT_HPP__
#define __TEXT_FONT_HPP__

#include "visual/sprite.hpp"
#include "visual/image_manager.hpp"
#include "visual/screen.hpp"

#include "text/class_export.hpp"

#include <map>
#include <vector>

namespace bear
{
  namespace text
  {
    /**
     * \brief A class representing a font.
     * \author Sebastien Angibaud
     */
    class TEXT_EXPORT font
    {
    private:
      /** \brief The map for the special characters. */
      typedef std::map<char, visual::sprite*> sprite_map;

    public:
      font( const visual::image& image_resource,
            const claw::math::coordinate_2d<unsigned int>& character_size );
      font( const font& that );
      ~font();

      const visual::sprite& operator[](char character) const;

      const claw::math::coordinate_2d<unsigned int>& get_size() const;

      void render_text( visual::screen& screen,
                        const claw::math::coordinate_2d<unsigned int>& pos,
                        const std::string& str ) const;

    private:
      const visual::sprite& get_sprite(char character) const;

      void create( const visual::image& image_resource );

      void create_sprite( const visual::image& image_resource,
                          const unsigned int index,
                          const unsigned int pos_x,
                          const unsigned int pos_y );

      void create_sprite( const visual::image& image_resource,
                          char c,
                          const unsigned int pos_x,
                          const unsigned int pos_y );

      void create_special_sprites( const visual::image& image_resource,
                                   unsigned int x, unsigned int y,
                                   unsigned int characters_per_line );

    private:
      /** \brief Fixed size of the characters. */
      claw::math::coordinate_2d<unsigned int> m_character_size;

      /**
       * \brief Sprites for letters and numbers.
       *
       * The order is :
       * - [0, 25] small letters,
       * - [26, 51] capital letters,
       * - [52, 61] numbers.
       */
      std::vector<visual::sprite*> m_sprites;

      /** \brief Sprites for special characters. */
      sprite_map m_special_sprites;

    }; // class font
  } // namespace text
} // namespace bear

#endif // __TEXT_FONT_HPP__
