/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file level_globals.hpp
 * \brief Some global classes in a level.
 * \author Julien Jorge
 */
#ifndef __ENGINE_LEVEL_GLOBALS_HPP__
#define __ENGINE_LEVEL_GLOBALS_HPP__

#include "audio/sound_manager.hpp"
#include "visual/image_manager.hpp"
#include "communication/post_office.hpp"

#include "engine/class_export.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief Some global classes in a level: the image_manager, the
     *        sound_manager and the post office.
     * \author Julien Jorge
     */
    class ENGINE_EXPORT level_globals
    {
    public:
      const visual::image& load_image( const std::string& file_name );
      audio::sound& load_sound( const std::string& file_name );
      audio::music& load_music( const std::string& file_name );

      const visual::image& get_image( const std::string& name );
      audio::sound& get_sound( const std::string& name );
      audio::music& get_music( const std::string& name );

      bool image_exists( const std::string& name ) const;
      bool sound_exists( const std::string& name ) const;
      bool music_exists( const std::string& name ) const;

      void register_item( communication::messageable& item );
      void release_item( communication::messageable& item );
      bool send_message
      ( const std::string& target, communication::message& msg );

      void set_ears_position( const claw::math::coordinate_2d<int>& position ); 

    private:
      /** \brief The image resources in the level. */
      visual::image_manager m_image_manager;

      /** \brief The sound resources in the level. */
      audio::sound_manager m_sound_manager;

      /** \brief The post office in the level. */
      communication::post_office m_post_office;

    }; // struct level_globals
  } // namespace engine
} // namespace bear

#endif // __ENGINE_LEVEL_GLOBALS_HPP__
