/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file item_with_decoration.hpp
 * \brief An item with a decoration (a sprite or an animation).
 * \author Sebastien Angibaud
 */
#ifndef __ENGINE_ITEM_WITH_DECORATION_HPP__
#define __ENGINE_ITEM_WITH_DECORATION_HPP__

#include "engine/basic_renderable_item.hpp"
#include "engine/with_decoration.hpp"
#include "engine/base_item.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief An item with a decoration (a sprite or an animation).
     *
     * \b template \b parameters :
     * - \a Base : the base class for this item. Must inherit from
     *    engine::base_item,
     *
     * The custom fields of this class are:
     * - sprite: sprite, the sprite of this item.
     * - animation: animation, the animation of this item.
     * - any field supported by the parent classes.
     *
     * \author Sebastien Angibaud
     */
    template<class Base>
    class item_with_decoration:
      public basic_renderable_item<Base>,
      public with_decoration
    {
      typedef basic_renderable_item<Base> super;
      
    public:
      virtual
      bool set_sprite_field( const std::string& name, visual::sprite* value );
      bool set_animation_field( const std::string& name, 
				visual::animation* value );

      void start();
      bool is_valid() const;
      void progress( universe::time_type elapsed_time );
      void get_visual( std::list<scene_visual>& visuals ) const;

    }; // class item_with_decoration
  } // namespace engine
} // namespace bear

#include "engine/code/item_with_decoration.tpp"

#endif // __ENGINE_ITEM_WITH_DECORATION_HPP__
