/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file input_network_reader.hpp
 * \brief Input reader for network game. Read the inputs of a distant player.
 * \author Julien Jorge
 */
#ifndef __ENGINE_INPUT_NETWORK_READER_HPP__
#define __ENGINE_INPUT_NETWORK_READER_HPP__

#include "engine/input_reader/input_reader.hpp"

#include <claw/isocket_stream.hpp>

#include "engine/class_export.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief Input reader for network game. Read the inputs of a distant
     *        player.
     * \author Julien Jorge
     */
    class ENGINE_EXPORT input_network_reader : public input_reader
    {
    public:
      input_network_reader( unsigned int player_index,
                            const std::string& address, int port );

    private:
      virtual void read_and_apply();

    private:
      /** \brief The socket on which we read the inputs. */
      claw::net::isocket_stream m_input;

    }; // class input_network_reader
  } // namespace engine
} // namespace bear

#endif // __ENGINE_INPUT_NETWORK_READER_HPP__
