/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file input_base_local_reader.hpp
 * \brief Base class for local input readers.
 * \author Julien Jorge
 */
#ifndef __ENGINE_INPUT_BASE_LOCAL_READER_HPP__
#define __ENGINE_INPUT_BASE_LOCAL_READER_HPP__

#include "engine/input_reader/input_reader.hpp"
#include "engine/controller_layout.hpp"
#include "input/input_listener.hpp"
#include "input/input_status.hpp"
#include "input/keyboard.hpp"
#include "input/joystick.hpp"
#include "input/mouse.hpp"

#include "engine/class_export.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief Base class for local input readers.
     * \author Julien Jorge
     */
    class ENGINE_EXPORT input_base_local_reader:
      public input_reader,
      public input::input_listener
    {
    public:
      input_base_local_reader( unsigned int player_index,
                               const controller_layout& layout );

    protected:
      virtual void send_start_action_to_player( player::action action ) = 0;
      virtual void send_stop_action_to_player( player::action action ) = 0;
      virtual void send_action_to_player( player::action action ) = 0;

    private:
      virtual void read_and_apply();

      virtual bool key_pressed( input::keyboard::key_code key );
      virtual bool key_released( input::keyboard::key_code key );
      virtual bool key_maintained( input::keyboard::key_code key );

      virtual bool button_pressed( input::joystick::joy_code button,
                                   unsigned int joy_index );
      virtual bool button_released( input::joystick::joy_code button,
                                    unsigned int joy_index );
      virtual bool button_maintained( input::joystick::joy_code button,
                                      unsigned int joy_index );

      virtual
      bool mouse_pressed( input::mouse::mouse_code button,
                          const claw::math::coordinate_2d<unsigned int>& pos );
      virtual
      bool mouse_released( input::mouse::mouse_code button,
                           const claw::math::coordinate_2d<unsigned int>& pos );
      virtual bool mouse_maintained
      ( input::mouse::mouse_code button,
        const claw::math::coordinate_2d<unsigned int>& pos );

    private:
      /** \brief The controller layout of the controlled player. */
      const controller_layout& m_layout;

      /** \brief The status of the controllers. */
      input::input_status m_input_status;

    }; // class input_base_local_reader
  } // namespace engine
} // namespace bear

#endif // __ENGINE_INPUT_BASE_LOCAL_READER_HPP__
