/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file input_layout.hpp
 * \brief This class manage the input system and the input controllers.
 * \author Julien Jorge
 */
#ifndef __ENGINE_INPUT_LAYOUT_HPP__
#define __ENGINE_INPUT_LAYOUT_HPP__

#include "engine/game_rules.hpp"
#include "engine/input_reader/input_reader.hpp"
#include "input/input_status.hpp"

#include "engine/class_export.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief This class manage the input system and the input controllers.
     * \author Julien Jorge
     */
    class ENGINE_EXPORT input_layout
    {
    public:
      input_layout( const game_rules& rules );
      ~input_layout();

      void update();

    private:
      void release_controllers();

      void create_input_player_1( const game_rules& rules );
      void create_input_player_2( const game_rules& rules );

    private:
      /** \brief Input reader for the first player. */
      input_reader* m_input_player_1;

      /** \brief Input reader for the second player. */
      input_reader* m_input_player_2;

    }; // class input_layout
  } // namespace engine
} // namespace bear

#endif // __ENGINE_INPUT_LAYOUT_HPP__
