/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file game_rules.hpp
 * \brief Parameters of the current game.
 * \author Julien Jorge
 */
#ifndef __ENGINE_GAME_RULES_HPP__
#define __ENGINE_GAME_RULES_HPP__

#include <string>
#include <vector>

#include "engine/class_export.hpp"

namespace bear
{
  namespace engine
  {
    class controller_layout;

    /**
     * \brief Parameters of the current game.
     * \author Julien Jorge
     */
    class ENGINE_EXPORT game_rules
    {
    public:
      /**
       * \brief Which kind of game is running.
       */
      enum mode
        {
          /** \brief Local game. */
          local,

          /** \brief Network game, the local player is the first player. */
          network_local_first,

          /** \brief Network game, the local player is the second player. */
          network_local_second

        }; // enum mode

    public:
      game_rules( const std::string& base_layout_file_name );

      unsigned char get_number_of_players() const;
      void set_number_of_players(unsigned char n);

      mode get_mode() const;
      void set_mode( mode m );

      const controller_layout& get_layout(unsigned char i) const;
      void set_layout(unsigned char i, const controller_layout& layout);

      const std::string& get_distant_address() const;
      void set_distant_address(const std::string& address);

      unsigned int get_distant_port() const;
      void set_distant_port(unsigned int port);

      void save_controller_layout( unsigned char i ) const;

    private:
      void load_controller_layout( unsigned char i );

    private:
      /**
       * \brief The base name for controller's layout file. We will add to its
       * name _i, where i is the controller index.
       */
      const std::string m_base_layout_file_name;

      /** \brief Number of players. */
      unsigned char m_number_of_players;

      /** \brief Which kind of game is running. */
      mode m_game_mode;

      /** \brief The layouts of the players' controls. */
      std::vector<controller_layout> m_layout;

      /** \brief The IP address of the distant game. */
      std::string m_distant_address;

      /** \brief The port of the distant game. */
      unsigned int m_distant_port;

    }; // class game_rules
  } // namespace engine
} // namespace bear

#endif // __ENGINE_GAME_RULES_HPP__
