/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file uniform_generator.hpp
 * \brief A generator for collision events, that generates always the same
 *        event, regardless of the zone.
 * \author Julien Jorge
 */
#ifndef __ENGINE_UNIFORM_GENERATOR_HPP__
#define __ENGINE_UNIFORM_GENERATOR_HPP__

#include "universe/physical_item.hpp"
#include "universe/zone.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief A generator for collision events, that generates always the same
     *        event, regardless of the zone.
     * \author Julien Jorge
     */
    template<class Event>
    class uniform_generator
    {
    public:
      /**
       * \brief Instanciate the collision event.
       * \param self (not used) The physical item in which the event will be
       *        added.
       */
      template<universe::zone::position Z>
      universe::collision_event*
      get( const universe::physical_item& self ) const
      {
        return new Event;
      }
    }; // class uniform_generator
  } // namespace engine
} // namespace bear

#endif // __ENGINE_UNIFORM_GENERATOR_HPP__
