/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file basic_renderable_item.cpp
 * \brief Implementation of the bear::engine::basic_renderable_item class.
 * \author Sebastien Angibaud
 */

/*----------------------------------------------------------------------------*/
/**
 * \brief Contructor.
 */
template<class Base>
bear::engine::basic_renderable_item<Base>::basic_renderable_item()
  : m_gap(0,0), m_z_position(0)
{

} // basic_renderable_item::basic_renderable_item()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
template<class Base>
bear::engine::basic_renderable_item<Base>::~basic_renderable_item()
{
} // basic_renderable_item::~basic_renderable_item()


/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type \c integer.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
template<class Base>
bool bear::engine::basic_renderable_item<Base>::set_integer_field
( const std::string& name, int value )
{
  bool ok = true;

  if (name == "gap_x")
    m_gap.x = value;
  else if (name == "gap_y")
    m_gap.y = value;    	
  else if (name == "pos_z")
    m_z_position = value;
  else
    ok = super::set_integer_field(name,value);

  return ok;
} // basic_renderable_item::set_integer_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Return the gap between the position of the item and the position of
 *        his sprite.
 */
template<class Base>
const claw::math::coordinate_2d<int>&
bear::engine::basic_renderable_item<Base>::get_gap() const
{
 return m_gap; 
} // basic_renderable_item::get_gap()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the gap between the position of the item and the position of his
 *        sprite.
 * \param gap The new value of the gap.
 */
template<class Base>
void bear::engine::basic_renderable_item<Base>::set_gap
( const claw::math::coordinate_2d<int>& gap )
{
  set_gap( gap.x, gap.y );
} // basic_renderable_item::set_gap()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the gap between the position of the item and the position of his
 *        sprite.
 * \param x The new X value of the gap.
 * \param y The new Y value of the gap.
 */
template<class Base>
void bear::engine::basic_renderable_item<Base>::set_gap( int x, int y )
{
  m_gap.set(x, y);
} // basic_renderable_item::set_gap()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the position of the item on the Z axis.
 */
template<class Base>
int bear::engine::basic_renderable_item<Base>::get_z_position() const
{
  return m_z_position;
} // basic_renderable_item::get_z_position()
