/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file basic_renderable_item.hpp
 * \brief A renderable item.
 * \author Sebastien Angibaud
 */
#ifndef __ENGINE_BASIC_RENDERABLE_ITEM_HPP__
#define __ENGINE_BASIC_RENDERABLE_ITEM_HPP__

#include <string>
#include <claw/coordinate_2d.hpp>

namespace bear
{
  namespace engine
  {
    /**
     * \brief A renderable item.
     *
     * \b template \b parameters :
     * - \a Base : the base class for this item. Must inherit from
     *    engine::base_item,
     *
     * \author Sebastien Angibaud
     */
    template<class Base>
    class basic_renderable_item: public Base
    {
      typedef Base super;

    public:
      basic_renderable_item();
      ~basic_renderable_item();

      virtual bool set_integer_field( const std::string& name, int value );

      const claw::math::coordinate_2d<int>& get_gap() const;
      void set_gap( const claw::math::coordinate_2d<int>& gap );
      void set_gap( int x, int y );

      int get_z_position() const;

    private:
      /** \brief The gap betwwen position of the item and  the position of his
          sprite. */
      claw::math::coordinate_2d<int> m_gap;
    
      /** \brief The Position of the item in the layer (used for the
          display). */
      int m_z_position;

    }; // class basic_renderable_item
  } // namespace engine
} // namespace bear

#include "engine/code/basic_renderable_item.tpp"

#endif // __ENGINE_BASIC_RENDERABLE_ITEM_HPP__
