/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file sound_effect.cpp
 * \brief Implementation of the bear::audio::sound_effect class.
 * \author Julien Jorge
 */
#include "audio/sound_effect.hpp"
#include <claw/assert.hpp>

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 *
 * Defaults values are :
 * - volume = 1
 * - loops = 0
 */
bear::audio::sound_effect::sound_effect()
  : m_volume(1), m_loops(0)
{

} // sound_effect::sound_effect()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the volume value.
 * \pre 0 <= volume <= 1
 */
void bear::audio::sound_effect::set_volume( double volume )
{
  CLAW_PRECOND( volume >= 0 );
  CLAW_PRECOND( volume <= 1 );

  m_volume = volume;
} // sound_effect::set_volume()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get volume value.
 */
double bear::audio::sound_effect::get_volume() const
{
  return m_volume;
} // sound_effect::get_volume()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the number of loops.
 *
 * The number of loops represent the number of time the sound will be played, in
 * addition to the default (one). So zero means on play, one means two and so
 * on. A value of -1 means infinite. All other negative values are incorrect.
 * \pre loops >= -1
 */
void bear::audio::sound_effect::set_loops( int loops )
{
  CLAW_PRECOND( loops >= -1 );

  m_loops = loops;
} // sound_effect::set_loops()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the number of loops.
 * \remark See set_loops for a detailed explanation of the meaning of the
 *         values.
 */
int bear::audio::sound_effect::get_loops() const
{
  return m_loops;
} // sound_effect::get_loops()
