/***************************************************************************
 *   Copyright (C) 2008 George Norton <george_norton_uk@hotmail.com>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef FlickrPlasmoid_HEADER
#define FlickrPlasmoid_HEADER
#include <KIcon>
#include <QBuffer>
#include <QHttp>
#include <QFile>
#include <QWebFrame>
#include <QWebPage>
#include <QBasicTimer>
#include <Plasma/Applet>
#include <Plasma/Svg>
 
class QSizeF;

enum widgetState{
  ELoadingXML,
  ELoadingImage,
  ELoadedImage,
  EFinished
};

class flickrImage
{
  public:
    QString id;
    QString secret;
    QString server;
    QString farm;
};
 
class FlickrPlasmoid : public Plasma::Applet
{
    Q_OBJECT
    public:
        FlickrPlasmoid(QObject *parent, const QVariantList &args);
        ~FlickrPlasmoid();

        void paintInterface(QPainter *painter,
                const QStyleOptionGraphicsItem *option,
                const QRect& contentsRect);
	void timerEvent(QTimerEvent *event);
	void init();
    private slots:

	void loaded( bool ok );
    private:
        Plasma::Svg m_svg;
        KIcon m_icon;
	QBasicTimer timer;
	QWebPage* page;
	QImage* image;
	QImage* image2;

	QString picUrl;

	int index;
	int count;
	int state;

	bool firstRun;

	QList<flickrImage> list; 
};

K_EXPORT_PLASMA_APPLET(euro2008, FlickrPlasmoid)
#endif 
