#!/bin/bash

_temp="/tmp/answer.$$"

function showPackagesMenu
{
	while true; do
		dialog --backtitle "Yawp's Packagegenerator" \
		       --title " Create Packages " \
		       --cancel-label "Quit" \
		       --menu "Select the package you want to create." 17 60 10 \
		       DEB	"Debian packages." \
		       RPM	"RPM package. Requires rpmbuild." \
		       STGZ	"Self extracting Tar GZip compressed packages." \
		       TBZ2	"Tar BZip2 compressed packages." \
		       TGZ	"Tar GZip compressed packages." \
		       TZ	"Tar compressed packages." \
		       ZIP	"Zip file packages."  2> $_temp

		opt=$?
		if [ $opt != 0 ]; then rm $_temp; return 0; fi
		menuitem=`cat $_temp`

		cpack -G $menuitem 2> $_temp

		opt=$?
		echo "cpack " $opt >> /tmp/cpack_opt
		if [ $opt == 0 ]; then
			dialog --msgbox "$menuitem-package has been successfully created. The packages will be stored in the build directory." 10 60
		else
			dialog --backtitle "Error creating $menuitem-package - use [up] [down] to scroll" \
		               --title " Error Message " \
			       --textbox $_temp 17 60
		fi
	done
}

function showMainMenu
{
	while true; do
		dialog --backtitle "Yawp's Packagegenerator" \
		       --title " Main Menu " \
		       --cancel-label "Quit" \
		       --menu "Instead of just installing the binaries, you also can create a package which can be installed using the package-manager of your distribution.\n\nMove using [UP] [DOWN] [TAB], [Enter] to select" 17 60 10 \
		       Packages "Create a package for your distribution." \
		       Install  "Install binaries and quit." \
		       Quit     "Exit install routine." 2> $_temp
	
		opt=$?
		if [ $opt != 0 ]; then rm $_temp; return 0; fi
		menuitem=`cat $_temp`
		case $menuitem in
			Packages) showPackagesMenu;;
			Install) return 0;;
			Quit) rm $_temp; exit;;
		esac
	done
	rm -f $_temp
}

function usage
{
cat <<EOF

usage: $0 [-d] [-u] [-h]

Compile and install yaWP KDE plasmoid

OPTIONS:
  -h  help
  -d  build with debug informations
  -u  build unittest directory 
EOF
}

##############################################################################################################

## Parse command lines arguments ## 

DEBUG=
UNITTESTS=

while getopts "hdu" OPT
do
	case $OPT in
	d) DEBUG="-DCMAKE_BUILD_TYPE=debugfull" ;;
	u) UNITTESTS="-DBUILD_UNITTESTS=YES" ;;
	?) usage ; exit ;;
	esac

done

echo "DEBUG: $DEBUG"
echo "UNITTESTS: $UNITTESTS"

rm --recursive --force build CMakeFiles CMakeTmp CMakeCache.txt cmake_install.cmake cmake_uninstall.cmake CTestTestfile.cmake Makefile

if [ ! -d build  ]; then
	mkdir build
fi

ret=$?
if [ $ret -ne 0 ]; then
	echo "Could not create build directory. Check your rights for this directory."
	exit
fi

cd build
cmake -DCMAKE_INSTALL_PREFIX=`kde4-config --prefix` $DEBUG $UNITTESTS ..

ret=$?
if [ $ret -ne 0 ]; then
	echo "CMake failed. Your system probably does not match all requirements."
	exit
fi

make clean
make

ret=$?
if [ $ret -ne 0 ]; then
	echo "Compilation failed, sorry :-("
	exit
fi

USERNAME=`whoami`

##  This is not really working, since cpack is installing the binaries in order to create the package ?!
##  So we need root privileges! - wired stuff that is not working the way i thought
##  Maybe somebody has a idea to solve this stuff.
##
##  Is it possible to install 
#if [ -n "`type dialog 2> /dev/null`" ]; then
#	if [ "$USERNAME" != "root" ]; then
#		echo -e "\\033[31m Creating the package needs root-privileges. Please enter root-password.\\033[m"
#		su
#	fi
#	showMainMenu
#	clear
#	exit	# to leave root privileges
#else
#	echo -e "\\033[1mAttention:\\033[m you might want to install package >dialog< for an easy way of creating packages for " \
#	     "your distribution. " \
#	     "But your also can use the following command in the build directory to create the package." \
#	     "The advantage of using packages is that you can use the package-manager of your distribution " \
#	     "to install or remove the software.\n\n\t\\033[33m cpack -G DEB \\033[m to create a Debian-package."
#fi


###### open dialog to ask if user wants to create a package or normaly install it

echo "Compilation done. Installing"
if [ "$USERNAME" != "root"  ]
then
	echo
	echo "The installation requires root privileges. "
	echo "Authentication required - CTRL+C to cancel:"
	sudo make install
else
	make install
fi

### Strip installed libs, when we installed them successfully.
### (Don't strip when debug requested)
#
ret=$?
if [ $ret -eq 0 -a -z "$DEBUG" ]
then
	echo "Stripping binaries ..."
	LIB=`kde4-config --install lib`
	[[ -f $LIB'kde4/plasma_yawp.so' ]]     && sudo strip $LIB'kde4/plasma_yawp.so'
	[[ -f $LIB'kde4/ion_accuweather.so' ]] && sudo strip $LIB'kde4/ion_accuweather.so'
	[[ -f $LIB'kde4/ion_google.so' ]]      && sudo strip $LIB'kde4/ion_google.so'
fi
