/*
 *   Copyright (C) 2008 Schutz Sacha <istdasklar@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   or (at your option) any later version, as published by the Free
 *   Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.*/

#ifndef LANGUAGEDIALOG_H
#define LANGUAGEDIALOG_H

#include <KListWidget>
#include <KDialog>
#include <QWidget>
#include <QMap>
#include <KIcon>
#include <QObject>

struct Language
{
QString code;
QString icon;
QString name;

};


class LanguageDialog:public KDialog
{
Q_OBJECT
    public:
      LanguageDialog(QWidget * parent=0);
      void setupLanguageMap();
      void setupListWidget();
      QListWidgetItem* findLanguage(QString langue);
      void addLanguage(Language l)
	{
	m_languageMap[l.name]=l;setupListWidget();
	m_listWidget->clear();
	setupListWidget();
	}
      void removeLanguage(QString l)
	{
	m_languageMap.erase(m_languageMap.find(l));
	m_listWidget->clear();
        setupListWidget();
	}

      QString code(){return m_language.code;}
      QString icon(){return m_language.icon;}
      QString name(){return m_language.name;}
      Language language(){return m_language;}
      KListWidget * listWidget(){return m_listWidget;}
      
    public slots:
      void setCurrentLanguage(); 


private:
     QMap <QString, Language> m_languageMap;
     KListWidget* m_listWidget;
     Language  m_language;
};

#endif