/*
 *   Copyright (C) 2008 Schutz Sacha <istdasklar@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   or (at your option) any later version, as published by the Free
 *   Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.*/





#include "ktranslatoid.h"
#include <QPainter>
#include <QFontMetrics>
#include <QSizeF>
#include <QMessageBox>
#include <plasma/svg.h>
#include <plasma/theme.h>
#include <KDebug>
#include <QGraphicsLinearLayout>
#include <QGraphicsSceneDragDropEvent>
#include <QNetworkAccessManager>
#include <QTextCodec>
#include <KTextEdit>
#include <KComboBox>
#include <KMessageBox>
#include <QTextEdit>
#include <QGraphicsRectItem>
#include <QToolButton>
#include <KPushButton>
 #include <QLabel>
#include <KConfigDialog>
#include <KStandardDirs>
#include <QGraphicsScene>
KTranslatoid ::KTranslatoid (QObject *parent, const QVariantList &args)
    :  Plasma::PopupApplet(parent, args)
{

    manager = new QNetworkAccessManager;
    m_textEditA = new  Plasma::TextEdit;
    m_textEditB = new  Plasma::TextEdit;
    m_buttonTranslate = new Plasma::PushButton;
    m_buttonChange = new Plasma::ToolButton;
    m_meter = new   Plasma::Meter;
    m_labelA = new Plasma::Label;
    m_labelB = new Plasma::Label;
    m_languageListWidget = new KListWidget;
    m_buttonA = new Plasma::ToolButton ;
    m_buttonB = new Plasma::ToolButton ;
    m_voiceForm = new VoiceForm;

    connect(manager, SIGNAL(finished(QNetworkReply*)),this, SLOT(replyFinished(QNetworkReply*)));
    connect(m_buttonTranslate,SIGNAL(clicked()),this, SLOT(translate()));
    connect(m_buttonChange,SIGNAL(clicked()),this, SLOT(changeSens()));
 
    connect(m_buttonA->nativeWidget(), SIGNAL(clicked()), this, SLOT( changeButtonA()));
    connect(m_buttonB->nativeWidget(), SIGNAL(clicked()), this, SLOT( changeButtonB()));
   
    connect(this, SIGNAL(activate()), this, SLOT(newShow()));


    setBackgroundHints(DefaultBackground);

    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
    setPopupIcon("translator");
    setAspectRatioMode(Plasma::IgnoreAspectRatio);


    m_languageA.code = "fr";
    m_languageA.name= "french";
    m_languageA.icon = "kbflags/fr.png";

    m_languageB.code = "en";
    m_languageB.name= "english";
    m_languageB.icon = "kbflags/gb.png";

    m_command = m_voiceForm->commandLine();


   constructForm();
 }
 //========================================================================================
 
KTranslatoid ::~KTranslatoid ()
{
    if (hasFailedToLaunch()) {
        // Do some cleanup here
    } else {
        // Save settings
    }
}
//====================================================================================
void KTranslatoid::constructForm()
{

  m_graphicsWidget = new QGraphicsWidget(this);

  Plasma::Frame *m_header = new Plasma::Frame;
  m_header->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);
  m_header->setText(i18n("Translatoid"));
  m_buttonChange->nativeWidget()->setIcon(KIcon("system-switch-user.png"));
  m_buttonChange->nativeWidget()->setToolTip(i18n("invert translation"));

  m_buttonTranslate->nativeWidget()->setIcon(KIcon("tools-wizard.png"));
  m_buttonTranslate->setText(i18n("Translate"));
  m_buttonTranslate->nativeWidget()->setToolTip(i18n("click to translate"));
  m_labelA->setText(m_languageA.name);
  m_labelB->setText(m_languageB.name);
  m_textEditB->nativeWidget()->setReadOnly (true);

  Plasma::ToolButton * pastButton= new Plasma::ToolButton ;
  Plasma::ToolButton * copyButton= new Plasma::ToolButton ;
  Plasma::ToolButton * clearButton= new Plasma::ToolButton ;
  Plasma::ToolButton * voiceButton= new Plasma::ToolButton ;


  voiceButton->nativeWidget()->setIcon(KIcon("text-speak.png"));
  voiceButton->setMinimumSize(QSize(20,20));
 
  
  pastButton->setMinimumSize(QSize(20,20));
  copyButton->setMinimumSize(QSize(20,20));
  clearButton->setMinimumSize(QSize(20,20));
  pastButton->nativeWidget()->setIcon(KIcon("edit-paste.png"));
  copyButton->nativeWidget()->setIcon(KIcon("edit-copy.png"));
  clearButton->nativeWidget()->setIcon(KIcon("edit-delete.png"));


  pastButton->nativeWidget()->setToolTip(i18n("Paste a selection to translate it"));
  copyButton->nativeWidget()->setToolTip(i18n("Copy the result "));
  clearButton->nativeWidget()->setToolTip(i18n("Clear the source text "));

  m_buttonA->nativeWidget()->setToolTip(i18n("Change source language"));
  m_buttonB->nativeWidget()->setToolTip(i18n("Change destination  language"));

  connect(pastButton->nativeWidget(), SIGNAL(clicked()), this, SLOT(paste()));
  connect(copyButton->nativeWidget(), SIGNAL(clicked()), this, SLOT(copy()));
  connect(clearButton->nativeWidget(), SIGNAL(clicked()), m_textEditA->nativeWidget(), SLOT(clear()));
  connect(voiceButton->nativeWidget(),SIGNAL(clicked()),this, SLOT(tts()));


  QGraphicsLinearLayout*  layoutControl = new QGraphicsLinearLayout(Qt::Horizontal);
  layoutControl->addItem(m_buttonA);
  layoutControl->addItem(m_buttonChange);
  layoutControl->addItem(m_buttonB);
  layoutControl->addItem(voiceButton);
  layoutControl->addStretch();
  layoutControl->addItem(clearButton);
  layoutControl->addItem(pastButton);
  layoutControl->addItem(copyButton);
  layoutControl->addItem(m_buttonTranslate);


  m_buttonA->nativeWidget()->setIcon(KIcon(m_languageA.icon));
  m_buttonB->nativeWidget()->setIcon(KIcon(m_languageB.icon));


  m_meter->setMinimum(0);
  m_meter->setMaximum(100);
  m_meter->setMeterType(Plasma::Meter::BarMeterHorizontal);
  m_meter->setMaximumHeight(20);  

  m_buttonA->setMinimumSize(QSize(20,20));
  m_buttonB->setMinimumSize(QSize(20,20));
  m_buttonChange->setMinimumSize(QSize(20,20));
  m_buttonTranslate->setMinimumSize(QSize(20,20));


  QGraphicsLinearLayout* mainLayout = new QGraphicsLinearLayout(Qt::Vertical);

  mainLayout->addItem(m_header);
  mainLayout->addItem(m_labelA);

  mainLayout->addItem(m_textEditA);
  mainLayout->addItem(m_labelB);

  mainLayout->addItem(m_textEditB);
  mainLayout->addItem(m_meter);
  mainLayout->addItem(layoutControl);

 
   QGraphicsWidget * widget = new QGraphicsWidget;
   widget->setLayout(mainLayout);
/*
   m_languageDialog = new LanguageDialog();

  m_leftWidget = new QGraphicsProxyWidget;
  m_leftWidget->setWidget(m_languageDialog);*/

  bigLayout = new QGraphicsLinearLayout(Qt::Horizontal);
  //bigLayout->addItem(m_leftWidget);
  bigLayout->addItem(widget);

  m_textEditA->nativeWidget()->setHtml ("Here your text source");

  m_graphicsWidget->setLayout(bigLayout);
  m_graphicsWidget->setPreferredSize(530, 320);

  m_textEditA->nativeWidget()->selectAll();


}
//====================================================================================
 QGraphicsWidget *KTranslatoid::graphicsWidget()
{
  return m_graphicsWidget;
}
//=============================================================================
void KTranslatoid ::translate()
{





  QString ln = m_languageA.code+"|"+m_languageB.code;
  QString txt= m_textEditA->nativeWidget()->toPlainText();

  QUrl url ("http://www.google.com/translate_t?hl=en&ie=UTF8&text="+txt+"&langpair="+ln);
  manager->get(QNetworkRequest(url));

  m_meter->setValue(0);
  reply = manager->get(QNetworkRequest(url));
  connect(reply, SIGNAL(downloadProgress ( qint64, qint64)), this, SLOT(updateMeter(qint64,qint64)));  
}
//===============================================================================
void KTranslatoid ::replyFinished(QNetworkReply* reply)
{
    QByteArray array = reply->readAll();
    QByteArray begin ="<div id=result_box";

     if (!array.contains(begin))
      {
       kDebug()<<"Can't get a from google source";
       m_textEditB->setText(i18n("Can't get a translation from google..."));
       return;
      }
    int index = array.indexOf(begin);
    QByteArray result;
    int i = index+29;
    bool end = false;
    while ( end == false)
    {
        QString a(array.at(i));
        QString t("<");
	if ( a == t)
            {
            end = true;
            break;
            }
    result.append(array.at(i));
    ++i;
  }
  result.replace("&#39;","'");



  QByteArray error = "uiv=\"content-type\" content=\"text/html;charset=utf-8\">";
  if ( result.contains(error))
   m_textEditB->nativeWidget()->setText("an error occurred");

  else
   m_textEditB->nativeWidget()->setText(result);

   copy();

}
//===================================================================================
void KTranslatoid::changeSens()
{
  Language tA = m_languageA;
  Language tB = m_languageB;

  m_languageA = tB;
  m_languageB = tA;

  m_buttonA->nativeWidget()->setIcon(KIcon(m_languageA.icon));
  m_labelA->setText(m_languageA.name);


  m_buttonB->nativeWidget()->setIcon(KIcon(m_languageB.icon));
  m_labelB->setText(m_languageB.name);
} 
//==========================================================================================
void KTranslatoid::updateMeter(qint64 bytesSent, qint64 bytesTotal)
{
  m_meter->setValue((bytesSent/bytesTotal)*100);
}
//====================================================================================
void KTranslatoid::changeButtonA()
  {
  m_leftWidget = new QGraphicsProxyWidget;
  m_languageDialog = new LanguageDialog;
  m_leftWidget->setWidget(m_languageDialog);
  bigLayout->insertItem ( 0,m_leftWidget);

  m_languageDialog->setWindowTitle("choose source Language");
  m_currentButton= 1;
  m_buttonA->setEnabled(false);
  m_buttonB->setEnabled(false);
  m_buttonChange->setEnabled(false);
  m_leftWidget->moveBy(500,0);
  Plasma::Animator::self()->moveItem(m_leftWidget,  Plasma::Animator::SlideInMovement, QPoint(0,0));
  connect(m_languageDialog,SIGNAL(accepted()),this, SLOT(collapseLeft()));
  connect(m_languageDialog,SIGNAL(rejected()),this, SLOT(collapseLeft()));
}

//====================================================================================
void KTranslatoid::changeButtonB()
{

  m_leftWidget = new QGraphicsProxyWidget;
  m_languageDialog = new LanguageDialog;
  m_leftWidget->setWidget(m_languageDialog);
  bigLayout->insertItem ( 0,m_leftWidget);
  m_languageDialog->setWindowTitle("choose result Language");
  m_languageDialog->removeLanguage("autodetect");
  m_currentButton = 2;

  m_buttonA->setEnabled(false);
  m_buttonB->setEnabled(false);
  m_buttonChange->setEnabled(false);
  m_leftWidget->moveBy(500,0);
  Plasma::Animator::self()->moveItem(m_leftWidget,  Plasma::Animator::SlideInMovement, QPoint(0,0));

 connect(m_languageDialog,SIGNAL(accepted()),this, SLOT(collapseLeft()));
 connect(m_languageDialog,SIGNAL(rejected()),this, SLOT(collapseLeft()));

}
//=======================================================================================
   void KTranslatoid::copy()
{
  m_textEditB->nativeWidget()->selectAll();
  m_textEditB->nativeWidget()->copy();
}
//=========================================================================================
  void KTranslatoid::paste()
{
  m_textEditA->nativeWidget()->clear();
  m_textEditA->nativeWidget()->paste();
}

//==========================================================================================
void KTranslatoid::tts()
{

  QString qcommand=m_command;
  qcommand.replace("$RESULT", m_textEditB->nativeWidget()->toPlainText());
  qcommand.replace("$SOURCE", m_textEditA->nativeWidget()->toPlainText());


  QByteArray ba = qcommand.toUtf8();
  const char *command = ba.data(); 
  system(command);


}
//==============================================================================================
 void KTranslatoid::createConfigurationInterface(KConfigDialog *parent)
{
m_voiceForm = new VoiceForm;

parent->addPage(m_voiceForm, i18n("Voice settings"), KStandardDirs::locate("icon", "oxygen/scalable/actions/text-speak.svgz"));


    connect(parent, SIGNAL(applyClicked()), this, SLOT(configAccepted()));
    connect(parent, SIGNAL(okClicked()), this, SLOT(configAccepted()));


}

//================================================================================================
void KTranslatoid::configAccepted()
{

  m_command = m_voiceForm->commandLine();


}
//================================================================================================
void KTranslatoid::collapseLeft()
{

  m_buttonA->setEnabled(true);
  m_buttonB->setEnabled(true);
  m_buttonChange->setEnabled(true);

if ( m_currentButton == 1)
{
  m_buttonA->nativeWidget()->setIcon(KIcon(m_languageDialog->icon()));
  m_labelA->setText(m_languageDialog->name());
  m_languageA = m_languageDialog->language();
  bigLayout->removeItem(m_leftWidget);

}


if ( m_currentButton == 2)
  {
  m_buttonB->nativeWidget()->setIcon(KIcon(m_languageDialog->icon()));
  m_labelB->setText(m_languageDialog->name());
  m_languageB = m_languageDialog->language();
  bigLayout->removeItem(m_leftWidget);
}


  m_currentButton=0;
}

//============================================================================================================
void KTranslatoid::popupEvent(bool show)
{
if ( show)
  {
  m_textEditA->grabKeyboard ();
  m_textEditA->nativeWidget()->clear();
  m_textEditA->nativeWidget()->paste();
  translate();

  }

  else
  {
  m_textEditA->ungrabKeyboard ();

  }

}



#include "ktranslatoid.moc"
