/***********************************************************************************
* STasks
* Copyright (C) 2009 Marcin Baszczewski <marcin.baszczewski@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

//OWN
#include "stasks_task.h"
#include "stasks_applet.h"
//QT
#include <QApplication>
//KDE
#include <KIcon>

STasksTask::STasksTask(TaskManager::AbstractGroupableItem *abstractItem, QObject *parent,STasksApplet *applet) : QObject(parent),
m_applet(applet)
{    
    m_abstractItem = abstractItem;
    if (abstractItem->isGroupItem())
    {	
	m_type = Group;
	m_group = static_cast<TaskManager::TaskGroup*>(abstractItem);
	connect(m_group, SIGNAL(changed(::TaskManager::TaskChanges)),this, SLOT(updateTask(::TaskManager::TaskChanges)));
	updateTask(::TaskManager::EverythingChanged);
    }
    else
    {
	m_task = static_cast<TaskManager::TaskItem*>(abstractItem);
	if (task())
	{
	    m_type = Task;
	    connect(m_task, SIGNAL(changed(::TaskManager::TaskChanges)),this, SLOT(updateTask(::TaskManager::TaskChanges)));
	    updateTask(::TaskManager::EverythingChanged);
	    emit gotTask();
	}
	else if (startup()) 
	{
	    m_type = Startup;
	    connect(m_task, SIGNAL(gotTaskPointer()), this, SLOT(gotTaskPointer()));
	    connect(m_task, SIGNAL(changed(::TaskManager::TaskChanges)),this, SLOT(updateTask(::TaskManager::TaskChanges)));
	    updateTask(::TaskManager::EverythingChanged);
	}

    }
}
STasksTask::~STasksTask()
{
}
bool STasksTask::isActive()
{
//     if (type()!=Group)
//     return taskItem()->isActive();
//     else
//     return groupItem()->isActive();
    return m_abstractItem->isActive();
}
bool STasksTask::isOnCurrentDesktop()
{
//     if (type()!=Group)
//     return taskItem()->isOnCurrentDesktop();
//     else
//     return groupItem()->isOnCurrentDesktop();
    return m_abstractItem->isOnCurrentDesktop();
}
bool STasksTask::isOnAllDesktops()
{
//     if (type()!=Group)
//     return taskItem()->isOnAllDesktops();
//     else
//     return groupItem()->isOnAllDesktops();
    return m_abstractItem->isOnAllDesktops();
}
bool STasksTask::isMinimized()
{
//     if (type()!=Group)
//     return taskItem()->isMinimized();
//     else
//     return groupItem()->isMinimized();
    return m_abstractItem->isMinimized();
}
bool STasksTask::demandsAttention()
{
//     if (type()!=Group)
//     return taskItem()->demandsAttention();
//     else
//     return groupItem()->demandsAttention();
    return m_abstractItem->demandsAttention();
}

STasksTask::ItemType STasksTask::type()
{
    return m_type;
}
QIcon STasksTask::icon()
{
    return m_icon;
}
QString STasksTask::text()
{
    QString temp;
    switch (type())
    {
	case Startup:
	    temp = startup()->text();
	    break;
	case Task:
	    temp = task()->visibleName();
	    break;
	case Group:
	    temp = group()->name();
	    break;
	case Other:
	    break;
    }
    return temp;
}
QString STasksTask::description()
{
    QString temp;
    switch (type())
    {
	case Startup:
	    temp = i18n("Starting application...");
	    break;
	case Task:
	    temp = (m_abstractItem->isOnAllDesktops()?i18n("On all desktops"):i18nc("Which virtual desktop a window is currently on", "On %1", KWindowSystem::desktopName(m_abstractItem->desktop())));
	    break;
	case Group:
	    temp = (m_abstractItem->isOnAllDesktops()?i18n("On all desktops"):i18nc("Which virtual desktop a window is currently on", "On %1", KWindowSystem::desktopName(m_abstractItem->desktop())));
	    break;
	case Other:
	    break;
    }
    return temp;
}
int STasksTask::desktop()
{
   return task()->desktop();
}
TaskPtr STasksTask::task()
{
    return m_task->task();
}
TaskManager::AbstractItemPtr STasksTask::abstractItem()
{
    return m_abstractItem;
}
TaskManager::TaskItem* STasksTask::taskItem()
{
    return m_task;
}
StartupPtr STasksTask::startup()
{
    return m_task->startup();
}
GroupPtr STasksTask::group()
{
    return m_group;
}
TaskFlags STasksTask::flags()
{
    return m_flags;
}
void STasksTask::popup(QPoint point)
{
    if (type() == Task || type() == Group)
    {
	QList<QAction*> actionList;
	TaskManager::BasicMenu *taskMenu;
	if (type() == Task)
        {
            taskMenu = new TaskManager::BasicMenu(qobject_cast<QWidget*>(this), m_task, m_applet->m_groupManager, actionList);
        }
        else
        {
            taskMenu = new TaskManager::BasicMenu(qobject_cast<QWidget*>(this), m_group, m_applet->m_groupManager, actionList);
        }
	taskMenu->popup(point);
    }
}
void STasksTask::updateTask(::TaskManager::TaskChanges changes)
{
//     if (type() != Task && type() != Group)
//     return;

    {
	bool needsUpdate = false;
	TaskFlags t_flags = m_flags;

	if (isActive()) 
	{
	    t_flags |= TaskHasFocus;
	} 
	else 
	{
	    t_flags &= ~TaskHasFocus;
	}
	if (demandsAttention()) 
	{
	    t_flags |= TaskWantsAttention;
	} 
	else 
	{
	    t_flags &= ~TaskWantsAttention;
	}
	if (isMinimized()) 
	{
	    t_flags |= TaskIsMinimized;
	} 
	else 
	{
	    t_flags &= ~TaskIsMinimized;
	}
	if (m_flags != t_flags) 
	{
	    needsUpdate = true;
	    m_flags = t_flags;
	    emit updateState();
	}
	if (changes & TaskManager::IconChanged) 
	{
	    switch (type())
	    {
		case Startup:
		    if (!KIcon(startup()->icon()).isNull())
		    m_icon = KIcon(startup()->icon());
		    break;
		case Task:
		    if (!KIcon(task()->icon()).isNull())
		    m_icon = KIcon(task()->icon());
		    break;
		case Group:
		    if (!KIcon(group()->icon()).isNull())
		    m_icon = KIcon(group()->icon());
		    break;
		case Other:
		    break;
	    }
	    emit updateIcon(m_icon);
	    needsUpdate = true;
	}
	if (changes & TaskManager::NameChanged) 
	{
	    needsUpdate = true;
	}
	if ( (changes & TaskManager::IconChanged || changes & TaskManager::NameChanged || changes & TaskManager::DesktopChanged)) 
	{
	    emit updateToolTip();
	    emit updateState();
	}
	if (needsUpdate) 
	{
	    emit update();
	}
    }
}
void STasksTask::gotTaskPointer()
{
    TaskManager::TaskItem *item = qobject_cast<TaskManager::TaskItem*>(sender());
    if (item) 
    {
        setWindowTask(item);
    }
}
void STasksTask::setWindowTask(TaskManager::TaskItem* taskItem)
{
    m_type = Task;
    if (m_task) 
    {
        disconnect(m_task->task().constData(), 0, this, 0);
    }
    m_task = taskItem;
    connect(m_task, SIGNAL(changed(::TaskManager::TaskChanges)),this, SLOT(updateTask(::TaskManager::TaskChanges)));
    updateTask(::TaskManager::EverythingChanged);
    emit gotTask();
}

#include "stasks_task.moc"