/***********************************************************************************
* STasks
* Copyright (C) 2009 Marcin Baszczewski <marcin.baszczewski@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

//OWN
#include "stasks_light.h"
#include "stasks_applet.h"
//QT
#include <QTimer>
#include <QPainter>
#include <QStyleOptionGraphicsItem>
//PLASMA
#include <Plasma/Applet>
#include <Plasma/PaintUtils>
//KDE
#include <KIcon>
#include <KIconEffect>
#include <KIconLoader>
//OTHER
#include <cmath>


STasksLight::STasksLight(QObject *parent,STasksApplet *applet) : QObject(parent),
    m_applet(applet),
    m_repeater(true)
{
    m_move = true;
    m_mouse = false;
    m_count = 0;
    m_animationRepeater = new QTimer();
    m_animation=0;
}
STasksLight::~STasksLight()
{
    if (m_animation) 
    {
        Plasma::Animator::self()->stopCustomAnimation(m_animation);
    }
    m_animationRepeater->deleteLater();
}
void STasksLight::paint(QPainter *p, const QStyleOptionGraphicsItem *option, QWidget *widget)
{
    Q_UNUSED(option);
    Q_UNUSED(widget);
    
    if ((!m_mouse) && (!m_animation)) return;


    if (m_currentAnimation=="animationStartup")
    {
	QPointF pos;
	qreal msize;
	QRectF temp = m_rect;
	temp.setLeft(temp.left()-4);
	temp.setTop(temp.top()-4);
	temp.setWidth(temp.width()+4);
	temp.setHeight(temp.height()+4);
	if (m_applet->formFactor() == Plasma::Vertical)
	{
	    pos = QPointF(temp.width()/2,temp.height()/2);
	    msize = temp.height();
	}
	else
	{
	    pos = QPointF(temp.width()/2,temp.height()/2);
	    msize = temp.width();
	}
	QRadialGradient radialGrad(pos, (msize)*2*((m_progress < 0.5)?((m_progress * 0.5) + 0.5):(1 - (m_progress / 2))));
	QColor lightColor = m_applet->lightColor();
	lightColor.setAlpha(200);
	radialGrad.setColorAt(0, lightColor);
	radialGrad.setColorAt(0.5, QColor(0,0,0,0));	
	p->setBrush(radialGrad);
	p->setPen(Qt::NoPen);


	p->drawRect(temp);
	p->setBrush(QBrush());
	p->setPen(QPen());
	
    }
    if (m_currentAnimation=="animationAttention")
    {
	QPointF pos;
	qreal msize;
	QRectF temp = m_rect;
	temp.setLeft(temp.left()-4);
	temp.setTop(temp.top()-4);
	temp.setWidth(temp.width()+4);
	temp.setHeight(temp.height()+4);
	if (m_applet->formFactor() == Plasma::Vertical)
	{
	    pos = QPointF(temp.width()/2,temp.height()/2);
	    msize = temp.height();
	}
	else
	{
	    pos = QPointF(temp.width()/2,temp.height()/2);
	    msize = temp.width();
	}
	QRadialGradient radialGrad(pos, (msize)*2*((m_progress < 0.5)?((m_progress * 0.5) + 0.5):(1 - (m_progress / 2))));
	QColor lightColor = m_applet->lightColor();
	lightColor.setAlpha(200);
	radialGrad.setColorAt(0, lightColor);
	radialGrad.setColorAt(0.5, QColor(0,0,0,0));	
	p->setBrush(radialGrad);
	p->setPen(Qt::NoPen);


	p->drawRect(temp);
	p->setBrush(QBrush());
	p->setPen(QPen());
    }
    if (m_currentAnimation=="")
    {
	QPointF pos;
	qreal msize;
	QRectF temp = m_rect;
	temp.setLeft(temp.left()-4);
	temp.setTop(temp.top()-4);
	temp.setWidth(temp.width()+4);
	temp.setHeight(temp.height()+4);

	if (m_applet->formFactor() == Plasma::Vertical)
	{
	    pos = QPointF(temp.width(),m_point.y());
	    msize = temp.height();
	}
	else
	{
	    pos = QPointF(m_point.x(), temp.height());
	    msize = temp.width();
	}
	QRadialGradient radialGrad(pos, (msize)*1.4);
	QColor lightColor = m_applet->lightColor();
	lightColor.setAlpha(200);
	radialGrad.setColorAt(0, lightColor);
	radialGrad.setColorAt(0.5, QColor(0,0,0,0));	
	p->setBrush(radialGrad);
	p->setPen(Qt::NoPen);


	p->drawRect(temp);
	p->setBrush(QBrush());
	p->setPen(QPen());
    }
}
void STasksLight::setRect(QRectF rect)
{
    if (rect!=m_rect)
    {
	m_rect=rect;
    }
}
void STasksLight::setPoint(QPointF point)
{
    if (m_point!=point)
    {
	m_point=point;
    }
}
void STasksLight::setMouse(bool mouse)
{
    m_mouse = mouse;
}
void STasksLight::startAnimation(QString animation,int duration,bool repeater)
{
    m_count=0;
    m_currentAnimationDuration = duration;
    m_currentAnimation = animation;

    m_animationRepeater->setInterval(duration);
    m_animationRepeater->start();
    
    
    repeatAnimation();

    m_repeater = repeater;
    connect(m_animationRepeater, SIGNAL(timeout()), this, SLOT(repeatAnimation()));
}
void STasksLight::stopAnimation()
{
    m_animationRepeater->stop();
    m_currentAnimation = "";
    Plasma::Animator::self()->stopCustomAnimation(m_animation);
    m_animation = 0;
}
void STasksLight::repeatAnimation()
{    
    if ( (!m_repeater) && (m_count!=0) )
    return;

    if (m_animation)
    {
        Plasma::Animator::self()->stopCustomAnimation(m_animation);
    }
    m_animation = Plasma::Animator::self()->customAnimation(m_applet->fps() / (1000 / m_currentAnimationDuration), m_currentAnimationDuration, Plasma::Animator::LinearCurve, this, "animation");
    m_count++;
}
void STasksLight::animation(qreal progress)
{
    m_progress = progress;  
    emit update();
}
#include "stasks_light.moc"