/***********************************************************************************
* STasks
* Copyright (C) 2009 Marcin Baszczewski <marcin.baszczewski@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/ 
#ifndef STASKSFRAME_H
#define STASKSFRAME_H

//QT
#include <QObject>
#include <QRectF>
#include <QHash>

class QStyleOptionGraphicsItem;
class QPainter;
class QWidget;
class STasksApplet;
namespace Plasma
{
    class FrameSvg;
}

class STasksFrame : public QObject
{
    Q_OBJECT

    public:
	STasksFrame(QObject *parent,STasksApplet *applet);
	~STasksFrame();
	void resize(QSizeF size);
	void paint(QPainter *p, const QStyleOptionGraphicsItem *option, QWidget *widget);
	void fade(QString prefix,int duration,bool fadeIn);
	QRectF contentsRect();
    private:
	Plasma::FrameSvg *m_frame;
	QSizeF m_size;
	STasksApplet *m_applet;
	bool m_fadeIn;
	int m_animation;
	qreal m_alpha;
	QString m_prefix;
	QString m_oldPrefix;
    private Q_SLOTS:
	void animation(qreal progress);
    Q_SIGNALS:
	void update();
};
#endif
