/***********************************************************************************
* STasks
* Copyright (C) 2009 Marcin Baszczewski <marcin.baszczewski@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

//OWN
#include "stasks_frame.h"
#include "stasks_applet.h"
//QT
#include <QApplication>
#include <QPainter>
#include <QFontMetrics>
#include <QGraphicsLinearLayout>
#include <QGraphicsSceneHoverEvent>
#include <QGraphicsSceneContextMenuEvent>
#include <QStyleOptionGraphicsItem>
#include <QGraphicsSceneMouseEvent>
#include <QTextLayout>
#include <QTime>
//KDE
#include <KIcon>
#include <KIconEffect>
#include <KIconLoader>
#include <KGlobalSettings>
#include <KColorUtils>
//PLASMA
#include <Plasma/FrameSvg>
#include <Plasma/Theme>
#include <Plasma/PaintUtils>
#include <Plasma/ToolTipManager>
#include <Plasma/IconWidget>

STasksFrame::STasksFrame(QObject *parent,STasksApplet *applet) : QObject(parent),
    m_applet(applet)
{
    m_animation=0;
    m_frame = m_applet->m_frame;
    m_prefix="normal";
    m_oldPrefix="normal";
}
STasksFrame::~STasksFrame()
{
    if (m_animation) 
    {
        Plasma::Animator::self()->stopCustomAnimation(m_animation);
    }
}
void STasksFrame::resize(QSizeF size)
{
    if (size!=m_frame->size() )
    {
	//m_frame->clearCache();
	m_size=size;
	m_frame->resizeFrame(m_size);
    }
}
QRectF STasksFrame::contentsRect()
{
    return m_frame->contentsRect();
}
void STasksFrame::paint(QPainter *p, const QStyleOptionGraphicsItem *option, QWidget *widget)
{
    Q_UNUSED(option);
    Q_UNUSED(widget);
    if (!m_animation)
    {
	m_frame->setElementPrefix(m_prefix);
	if (m_frame->framePixmap().isNull())
	{
	    kDebug() << "framePixmap is null";
	    return;
	}
	m_frame->paintFrame(p);
	return;
    }
    m_frame->setElementPrefix(m_oldPrefix);
    QPixmap oldBackground = m_frame->framePixmap();
    m_frame->setElementPrefix(m_prefix);
    QPixmap newBackground = m_frame->framePixmap();
    
    if ( (oldBackground.isNull()) || (newBackground.isNull()) )
    {
	kDebug() << "background is null";
	return;
    }
    QPixmap result = Plasma::PaintUtils::transition(oldBackground, newBackground, m_alpha);
    p->drawPixmap(QPoint(0,Plasma::TopMargin), result);
}
void STasksFrame::fade(QString prefix,int duration,bool fadeIn)
{
    m_oldPrefix = m_prefix;
    m_prefix = prefix;

    if (m_animation)
    {
        Plasma::Animator::self()->stopCustomAnimation(m_animation);
    }
    m_fadeIn = fadeIn;
    m_animation = Plasma::Animator::self()->customAnimation(m_applet->fps() / (1000 / duration), duration,Plasma::Animator::LinearCurve, this, "animation");
}

void STasksFrame::animation(qreal progress)
{
    if (qFuzzyCompare(qreal(1.0), progress)) 
    {
        m_animation = 0;
        m_fadeIn = true;
	emit update();
    }
    m_alpha = progress;
    emit update();
}
#include "stasks_frame.moc"