/***************************************************************************
 *   Copyright (C) 2009 by Kai Dombrowe <just89@gmx.de>                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef PGAME
#define PGAME


/// Qt
#include <QModelIndex>
#include <QGraphicsSceneDragDropEvent>

/// KDE
#include <Plasma/PopupApplet>
#include <KConfigDialog>
#include <KUrl>
#include <Plasma/ExtenderItem>
#include <Plasma/Extender>

/// own
#include "ui_settings.h"
#include "ui_gamedialog.h"
#include "ui_appearance.h"


class GameModel;
class GameList;
class GameItem;
class PGame : public Plasma::PopupApplet
{
	Q_OBJECT


public:
	PGame( QObject *parent, QVariantList args );
	~PGame();
	void init();


private:
	GameList *list;
	GameModel *model;
	Ui::Settings ui_settings;
	Ui::GameDialog ui_game;
	Ui::Appearance ui_appearance;

	QString _extraCmd;
	KUrl _tmpDir;
	KUrl _xBinary;
	bool _locateTmp;
	bool _locateBinary;

	QColor _color;
	QFont _font;
	Plasma::Applet::BackgroundHint _background;
	bool _frame;

	GameItem *selectedGame;


private slots:
	void startGame( const QModelIndex& idx );
	void saveGameConfig();
	void saveGeneralConfig();
	void saveAppearanceConfig();
	void loadConfig();
	void loadAppearanceConfig();
	void createConfigurationInterface( KConfigDialog *p_parent );
	void createNewGame();
	void setupAddDialog();
	void removeSelectedGames();
	void editSelectedGame();
	void saveSelectedGame();
	void dialogCancel();
	void updateCmd();
	void readFromDesktopFile( const QString& path, QString &name, QString &icon, QString &cmd, bool &game );


protected:
	QGraphicsWidget* graphicsWidget();
	void dragEnterEvent( QGraphicsSceneDragDropEvent *event ); 
	void dropEvent( QGraphicsSceneDragDropEvent *event ); 


};



#endif
