/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "kbfxthemesdata.h"

KbfxThemesData::KbfxThemesData()
{}

KbfxThemesData::~KbfxThemesData()
{
	m_themesMap.clear();
}

ThemesMap KbfxThemesData::setThemeList ( QString path )
{
	m_themesMap.clear();

	KStandardDirs *tmp = new KStandardDirs();

	/* search themes in KDE Resource Folders and append user selected folder */
	QStringList skinsFolders = tmp->findDirs ( "data", "kbfx/skins" );
	skinsFolders.append ( path );

	for ( QStringList::Iterator skinsIt = skinsFolders.begin(); skinsIt != skinsFolders.end(); ++skinsIt )
	{
		QDir d ( *skinsIt );
		d.setFilter ( QDir::Dirs );

		QFileInfoList list = d.entryInfoList();

                for (int i = 0; i < list.size(); ++i)
		{
                    QFileInfo fi = list.at(i);
			if ( !fi.fileName().contains ( "." ) )
				m_themesMap[fi.fileName() ] = (fi.dirPath ( TRUE ) ).append ( "/" );

		}
	}

	/* kdDebug() << "Available Themes - "
	 *           << m_themesMap.keys()
	 *           << m_themesMap.values()
	 *           << endl;
	 */

	return m_themesMap;
}
