//GPL2 siraj@kde.org


#ifndef WELLCOME_ITEM_H
#define WELLCOME_ITEM_H

#include <QGraphicsItem>
#include <QtCore/QObject>
#include <QtGui/QGraphicsTextItem>
#include <QtGui/QLayoutItem>
//plasma
#include <plasma/svg.h>
#include <plasma/theme.h>
#include <plasma/widgets/widget.h>
#include <plasma/datacontainer.h>
#include <qimageblitz/qimageblitz.h>
///#include "raptorlet.h"
//#include "../plasmicraptor_export.h"


class  WellcomeItem: public Plasma::Widget
{
Q_OBJECT
    public:

    typedef enum { REGULAR,OVER,PRESSED } MouseState;
    typedef QHash <MouseState,QString> ThemeNames;

    WellcomeItem(QGraphicsItem * parent = 0);
    virtual ~WellcomeItem();


    void paint( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0);


    QSizeF sizeHint() const;
    QSizeF minimumSize() const; 
    QSizeF maximumSize() const ;
    QRectF boundingRect() const;

    Qt::Orientations expandingDirections() const{return Qt::Horizontal;}

    QRectF geometry() const;
    void setGeometry(const QRect&) {}
    
    bool isEmpty() const {return false;}
    
    QString name();
    void setName(const QString& name);
    
    void setOpacity(float op);

    void setIcon(QPixmap icon);

    public slots:
        void zoom(int step);
    signals:
        void  clicked();
    protected:
	virtual void hoverEnterEvent ( QGraphicsSceneHoverEvent * event );
	virtual void hoverMoveEvent ( QGraphicsSceneHoverEvent * event );
	virtual void hoverLeaveEvent ( QGraphicsSceneHoverEvent * event );
    protected:
        QImage reflection(QImage& src);
        void paintItem(QPainter * painter,const QRectF );
    //    void paintItemRef(QPainter * painter,const QRectF);
    private:
    QString loadSvg(MouseState state);
    class Private;
    Private * const d ;

};

#endif
