function dump(obj)
{
  print( 'Dumping ' + obj );
  for( i in obj ) {
       print(i);
  }
}

print('ScriptWeather.js: Launched');

// Setup
applet.drawStandardBackground = true;
applet.hasConfigurationInterface = true;

// Setup data source
applet.weather = applet.getDataEngine('weather');
applet.location = 'Calgary, AB';

applet.paintInterface = function(painter)
{
  data = applet.weather.query( applet.location );
  for ( var i in data ) {
    print(i + ' -> ' + data[i] );
  }
}

applet.locationChanged = function()
{
  applet.location = applet.ui.locationEdit.text;
  data = applet.weather.query( applet.location );

  var s = '';
  for ( var i in data ) {
    s = s + '<b>' + i + ':</b> ' + data[i] + '<br>';
  }

  applet.ui.resultsEdit.html = s;
}

applet.showConfigurationInterface = function()
{
   print('applettest.js: Show configuration interface');

   applet.ui = loadui( applet.findDataResource('weather_applet.ui') );
   applet.ui.locationEdit.text = applet.location;
   applet.ui.resultsEdit.html = '<h1>Hello World</h1>';

   applet.ui.searchButton.clicked.connect(applet.locationChanged);
   applet.ui.show();
}


applet.configAccepted = function()
{
}

// Hack, should do this properly
applet.timer = new QTimer(applet);
applet.timer.start(10*1000);
applet.timer.timeout.connect( applet.update );
