/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *
 *   Copyright (C) 2007 by Javier Goday <jgoday@gmail.com>
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef KGET_PIEGRAPH_H
#define KGET_PIEGRAPH_H

#include <QColor>
#include "transfergraph.h"

#define TRANSFER_PIEGRAPH_WIDTH 140
#define TRANSFER_PIEGRAPH_HEIGHT 140

class QBrush;

static const QColor MyColors[] = {
    QColor(Qt::yellow),
    QColor(Qt::blue),
    QColor(Qt::darkMagenta),
    QColor(Qt::red),
    QColor(Qt::green),
    QColor(Qt::darkYellow)
};

class PieGraph : public TransferGraph
{
    Q_OBJECT

public:
    PieGraph(QObject *parent = 0);

    void paint(QPainter *p, const QRect &contentsRect);
    QSizeF contentSizeHint();

private:
    int drawPie(QPainter *, const QRect &, int angle, int percent, const QBrush &brush);
    void drawLegend(QPainter *p, int y, const QString &name, int percent, double size, const QColor &color);

    int m_totalFiles;
};

#endif
