/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2017, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * http://plantuml.com/patreon (only 1$ per month!)
 * http://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PlantUML distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 *
 * Original Author:  Arnaud Roques
 * 
 *
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.Log;

public class Preprocessor extends ReadLineInstrumented implements ReadLine {

	private final PreprocessorInclude include;
	private final SubPreprocessor subPreprocessor;
	private final String description;

	public Sub getSub(String blocname) {
		return subPreprocessor.getSub(blocname);
	}

	// public Preprocessor(List<String> config, ReadLine reader, String charset, Defines defines, File newCurrentDir,
	// DefinitionsContainer definitionsContainer) {
	//
	// final ReadLine source2 = new IfManager(reader, defines);
	// final ReadLineInsertable source3 = new ReadLineInsertable(source2);
	// final ReadLine source4 = new PreprocessorDefine(defines, source3);
	// this.include = new PreprocessorInclude(config, source4, defines, charset, newCurrentDir, definitionsContainer);
	// this.subPreprocessor = new SubPreprocessor(config, charset, defines, definitionsContainer, include);
	// }

	public Preprocessor(List<String> config, ReadLine reader, String charset, Defines defines, File newCurrentDir,
			DefinitionsContainer definitionsContainer) {
		this.description = reader.toString();
		this.include = new PreprocessorInclude(config, reader, defines, charset, newCurrentDir, definitionsContainer);
		final ReadLine source2 = new IfManager(include, defines);
		final ReadLineInsertable source3 = new ReadLineInsertable(source2);
		final ReadLine source4 = new PreprocessorDefine(defines, source3);
		this.subPreprocessor = new SubPreprocessor(config, charset, defines, definitionsContainer, source4);
	}

	@Override
	CharSequence2 readLineInst() throws IOException {
		return subPreprocessor.readLine();
	}

	public int getLineNumber() {
		return include.getLineNumber();
	}

	@Override
	void closeInst() throws IOException {
		// Log.info("Closing preprocessor of " + description);
		include.close();
		subPreprocessor.close();
	}

	public Set<FileWithSuffix> getFilesUsed() {
		return Collections.unmodifiableSet(include.getFilesUsedGlobal());
	}

}