/* Plagiat gallery creation tool for Jakub Steiner's O.R.I.G.I.N.A.L 
 * photo gallery.
 * Copyright (C) 2005 Robert Staudinger <robert.staudinger@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <string.h>
#include "pgt-utils.h"

gboolean 
pgt_runs_from_srcdir (void)
{
	static gint runs_from_src_dir = -1;

	if (runs_from_src_dir > -1) {
		return runs_from_src_dir;
	}

	/* enable running from src tree */
	do {
		gchar 	*bwd = NULL;
		gchar 	*cwd = NULL;
		cwd = g_get_current_dir ();
		bwd = g_path_get_dirname (g_get_current_dir ());
		if (0 == strcmp ("/src", cwd + strlen (bwd))) {
			runs_from_src_dir = TRUE;
			g_warning (_("Running from source tree"));
		}
		else {
			runs_from_src_dir = FALSE;
		}
	} while (0);

	return runs_from_src_dir;
}
