#!/bin/sh

set -e
. ./testsuite/common.sh

composerpkg='testsuite/data/composerpkg1'

sed "s@/usr/share/pkg-php-tools/scripts/phppkginfo@${PWD}/lib/scripts/phppkginfo@" bin/dh_phpcomposer > bin/dh_phpcomposer.test

ret=0
old_dir="${PWD}"

cd "${composerpkg}"
expect_equal "perl '${old_dir}/bin/dh_phpcomposer.test'" '' || ret=$?
expect_equal "cat 'debian/php-foo.substvars'" 'phpcomposer:name=vendor/project
phpcomposer:description=Some vendor project
phpcomposer:Debian-require=php5 (>= 5.2) | php5-cli (>= 5.2), php-symfony-yaml (>= 2.0), php-symfony-yaml (<< 3~)
phpcomposer:Debian-require-dev=overrideme-sub (>= 3.7~), overrideme-sub (<< 3.8~)
phpcomposer:Debian-provide=php-example-project (>= 1.7~), php-example-project (<< 1.8~), php5-curl
phpcomposer:Debian-suggest=php5-apc, php5-curl' || ret=$?
rm -f debian/php-foo.substvars debian/php-foo.debhelper.log
cd "${old_dir}"

rm bin/dh_phpcomposer.test

exit $ret
