/*

Copyright (C) 2000  Paul Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/* render_image.c by Paul Wilkins 1/2/2000 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk_imlib.h>

#include "globals.h"
#include "status.h"
#include "read_db.h"
#include "draw_image.h"
#include "render_image.h"


void find_next(struct IMAGE_INFO **image, struct PIC_DB *db, int *col, int *row, int nPixW, int nPixH){
   int r, c, cl;
   cl = (*col) + 1;
   for(r=*row; r<nPixH; r++){
      for(c=cl; c<nPixW; c++){
         if(db == image[r][c].db){
            *row = r;
            *col = c;
            return;
         }
      }
      cl = 0;
   }
   fprintf(stderr, "Error: Can't find next match\n");
   exit(1);
}

void copy_image_RGB(
   unsigned char *scale_data, 
   unsigned char *dest_data, 
   int col, 
   int row) 
{
   int x, y;
   unsigned char *p1, *p2;

   p1 = scale_data;
   for(y=0; y<globals.cur_opt.pixH; y++){

      p2 = dest_data +
           3*(((y+row*globals.cur_opt.pixH)*globals.cur_opt.width) +
           (col*globals.cur_opt.pixW));

      for(x=0; x<globals.cur_opt.pixW; x++){

	 /* copy RGB */
	 *p2++ = *p1++;
	 *p2++ = *p1++;
	 *p2++ = *p1++;
      }
   }
}

GdkImlibImage *render_image(struct IMAGE_INFO **image, int nPixW, int nPixH, int pixW, int pixH){
   int i;
   double percent;
   GdkImlibImage *new_im;
   int row, col;
   unsigned char *data;
   int width, height;
   int ww, hh;
   GdkImlibImage *im;
   GdkImlibImage *scale_im;

   width = nPixW * pixW;
   height = nPixH * pixH;

   /* malloc the output image data */
   if(NULL == (data=malloc(3*width*height*sizeof(unsigned char)))){
      perror("malloc");
      return 0;
   }

   /* update the progress bar */
   set_progress_indicator(0.0);

   for(hh=0; hh<nPixH; hh++){
      for(ww=0; ww<nPixW; ww++){

         /* skip this image if it has already been rendered; */
         if(image[hh][ww].db->done == 1) continue; 
         image[hh][ww].db->done = 1;

         /* load the image */
         if(NULL == (im=gdk_imlib_load_image(image[hh][ww].db->fname))){
            fprintf(stderr, "Error: Unable to open %s\n", image[hh][ww].db->fname);
            continue;
         }

         /* scale the image */
         if(NULL == (scale_im=gdk_imlib_clone_scaled_image(im, pixW, pixH))){
            fprintf(stderr, "Error: Unable to scale image %s\n", image[hh][ww].db->fname);
            continue;
         }

         /* copy the image data into the output data */
         for(i=0; i<image[hh][ww].db->refcnt; i++){
            if(i == 0){
	       row = hh;
	       col = ww;
            } else {
               find_next(image, image[hh][ww].db, &col, &row, nPixW, nPixH);
            }

            draw_small_image(scale_im, col, row);

            copy_image_RGB(scale_im->rgb_data, data, col, row);

         }

         /* free the images */
         gdk_imlib_kill_image(im);
         gdk_imlib_kill_image(scale_im);

         /* update the progress bar */
         percent = (double)(hh*nPixW + ww + 1) / (double)(nPixH*nPixW);
         set_progress_indicator(percent);
      }
   }

   /* create a new GdkImlibImage */
   if(NULL == (new_im = gdk_imlib_create_image_from_data(data, NULL, width, height))){
      fprintf(stderr, "Error: Unable to create output image.\n");
      return NULL;
   }

   /* free the data */
   free(data);

   return new_im;

}
