/***************************************************************************
*            qof-address.c
*
*  Thu Oct 21 12:44:16 2004
*  Copyright  2004-2005  Neil Williams  <linux@codehelp.co.uk>
****************************************************************************/

/*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "qof-address.h"
#include "pilot-todo.h"
#include "pilot-qof.h"

#define ADDRESS_VERSION address_v1
#define QOF_ADDRESS_DESC "Pilot-link QOF address"

static char* printable = NULL;
static QofLogModule log_module = PQ_MOD_PILOT;

qof_addr *
address_create (QofBook *book)
{
	Address_t *qa;
	qof_addr *obj;
	QofCollection *coll;
	GList *all;

	obj = g_new0(qof_addr, 1);
	qof_instance_init (&obj->inst, PILOT_LINK_QOF_ADDRESS, book);
	coll = qof_book_get_collection (book, PILOT_LINK_QOF_ADDRESS);
	all = qof_collection_get_data (coll);
	all = g_list_prepend (all, obj);
	qof_collection_set_data (coll, all);
	qa = &obj->wrap;
	qa->entry[19] = strdup ("");
	return obj;
}

static char *
addr_getLastname (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryLastname];
}

static char *
addr_getFirstname (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryFirstname];
}

static char *
addr_getCompany (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryCompany];
}

static char *
addr_getPhoneOne (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryPhone1];
}

static char *
addr_getPhoneTwo (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryPhone2];
}

static char *
addr_getPhoneThree (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryPhone3];
}

static char *
addr_getPhoneFour (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryPhone4];
}

static char *
addr_getPhoneFive (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryPhone5];
}

static char *
addr_getCity (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryCity];
}

static char *
addr_getState (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryState];
}

static char *
addr_getZip (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryZip];
}

static char *
addr_getCountry (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryCountry];
}

static char *
addr_getTitle (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryTitle];
}

static char *
addr_getAddress (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryAddress];
}

static char *
addr_getCustomOne (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryCustom1];
}

static char *
addr_getCustomTwo (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryCustom2];
}

static char *
addr_getCustomThree (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryCustom3];
}

static char *
addr_getCustomFour (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryCustom4];
}

static char *
addr_getNote (qof_addr * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryNote];
}

static char *
addr_getCategory (qof_addr * a)
{
	g_return_val_if_fail (a != NULL, NULL);
	return (a->category);
}

static void
addr_setLastname (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if(!h) { return; }
	qa = &a->wrap;
	qa->entry[entryLastname] = strdup (h);
}

static void
addr_setFirstname (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if(!h) { return; }
	qa = &a->wrap;
	qa->entry[entryFirstname] = strdup (h);
}

static void
addr_setCompany (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	qa = &a->wrap;
	qa->entry[entryCompany] = strdup (h);
}

static void
addr_setPhoneOne (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if(!h) { return; }
	qa = &a->wrap;
	qa->entry[entryPhone1] = strdup (h);
}

static void
addr_setPhoneTwo (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	qa = &a->wrap;
	qa->entry[entryPhone2] = strdup (h);
}

static void
addr_setPhoneThree (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if(!h) { return; }
	qa = &a->wrap;
	qa->entry[entryPhone3] = strdup (h);
}

static void
addr_setPhoneFour (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	qa = &a->wrap;
	qa->entry[entryPhone4] = strdup (h);
}

static void
addr_setPhoneFive (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if(!h) { return; }
	qa = &a->wrap;
	qa->entry[entryPhone5] = strdup (h);
}

static void
addr_setAddress (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if(!h) { return; }
	qa = &a->wrap;
	qa->entry[entryAddress] = strdup (h);
}

static void
addr_setCity (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	qa = &a->wrap;
	qa->entry[entryCity] = strdup (h);
}

static void
addr_setState (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	qa = &a->wrap;
	qa->entry[entryState] = strdup (h);
}

static void
addr_setZip (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if(!h) { return; }
	qa = &a->wrap;
	qa->entry[entryZip] = strdup (h);
}

static void
addr_setCountry (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	qa = &a->wrap;
	qa->entry[entryCountry] = strdup (h);
}

static void
addr_setTitle (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if(!h) { return; }
	qa = &a->wrap;
	qa->entry[entryTitle] = strdup (h);
}

static void
addr_setCustomOne (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if(!h) { return; }
	qa = &a->wrap;
	qa->entry[entryCustom1] = strdup (h);
}

static void
addr_setCustomTwo (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if(!h) { return; }
	qa = &a->wrap;
	qa->entry[entryCustom2] = strdup (h);
}

static void
addr_setCustomThree (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a);
	if(!h) { return; }
	qa = &a->wrap;
	qa->entry[entryCustom3] = strdup (h);
}

static void
addr_setCustomFour (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a);
	if(!h) { return; }
	qa = &a->wrap;
	qa->entry[entryCustom4] = strdup (h);
}

static void
addr_setNote (qof_addr * a, const char *h)
{
	Address_t *qa;

	g_return_if_fail (a);
	if(!h) { return; }
	qa = &a->wrap;
	qa->entry[entryNote] = strdup (h);
}

static void
addr_setCategory (qof_addr * a, const char *h)
{
	g_return_if_fail (a);
	if(!h) { return; }
	a->category = strdup (h);
}

int
address_pack(QofEntity *ent, gpointer user_data)
{
	pilot_qof_data *context;
	Address_t   *qa;
	qof_addr    *obj;
	int size;

	size = 0;
	context = (pilot_qof_data*)user_data;
	g_return_val_if_fail((context || ent), -1);
	ENTER (" ");
	obj = (qof_addr*)ent;
	qa = &obj->wrap;
	size = pack_Address(qa, context->pi_buf, ADDRESS_VERSION);
	LEAVE (" result=%d", size);
	return size;
}

int
address_unpack(QofEntity *ent, gpointer user_data)
{
	pi_buffer_t *pi_buf;
	Address_t   *qa;
	pilot_qof_data *context;
	qof_addr    *obj;
	int size;

	context = (pilot_qof_data*)user_data;
	g_return_val_if_fail(context != NULL, -1);
	g_return_val_if_fail(ent != NULL, -1);
	ENTER (" ");
	obj = (qof_addr*)ent;
	qa = &obj->wrap;
	pi_buf = (pi_buffer_t*)context->pi_buf;
	size = 0;
	size = unpack_Address(qa, pi_buf, ADDRESS_VERSION);
	addr_setCategory(obj, context->pi_cat.name[context->ent_category]);
	LEAVE (" ");
	return size;
}

int
addr_appinfo_unpack(QofEntity *ent, gpointer user_data)
{
	AddressAppInfo_t app_a;
	pilot_qof_data *context;

	/* There is never an entity at this stage */
	context = (pilot_qof_data*)user_data;
	g_return_val_if_fail(context != NULL, -1);
	ENTER (" ");
	unpack_AddressAppInfo(&app_a, context->app_buf->data, context->app_buf->used);
	context->pi_cat = app_a.category;
	LEAVE (" ");
	return 0;
}

int
qof_address_free(QofEntity *ent, gpointer user_data)
{
	Address_t *qa;
	qof_addr *obj;

	g_return_val_if_fail(ent != NULL, -1);
	ENTER (" ");
	obj = (qof_addr*)ent;
	if(printable) { g_free(printable); }
	qa = &obj->wrap;
	free_Address(qa);
	LEAVE (" ");
	return 0;
}

static const char*
addressPrintable (gpointer instance)
{
	qof_addr *obj;

	obj = (qof_addr*)instance;
	if(!obj) return NULL;
	if(printable) { g_free(printable); }
	if(addr_getFirstname(obj)) 
	{ 
		printable = g_strconcat(
			addr_getFirstname(obj), " ", addr_getLastname(obj), NULL);
		return printable;
	}
	else {
		return addr_getTitle(obj);
	}
}

static QofObject address_object_def = {
      interface_version: QOF_OBJECT_VERSION,
      e_type:            PILOT_LINK_QOF_ADDRESS,
      type_label:        QOF_ADDRESS_DESC,
      create:            (gpointer) address_create,
      book_begin:        NULL,
      book_end:          NULL,
      is_dirty:          qof_collection_is_dirty,
      mark_clean:        qof_collection_mark_clean,
      foreach:           qof_collection_foreach,
      printable:         addressPrintable,
      version_cmp:       (int (*)(gpointer, gpointer)) qof_instance_version_cmp,
};

static pilot_pack address_pack_def = {
        e_type:          PILOT_LINK_QOF_ADDRESS,
        pack_func:       address_pack,
        unpack_func:     address_unpack,
        free_pack_func:   qof_address_free,
        palm_db_name:    "AddressDB",
        app_info_unpack: addr_appinfo_unpack,
};

gboolean
AddressRegister (void)
{
	static QofParam params[] = {
		{ADDR_LAST_NAME,  QOF_TYPE_STRING, (QofAccessFunc) addr_getLastname,  (QofSetterFunc) addr_setLastname},
		{ADDR_FIRST_NAME, QOF_TYPE_STRING, (QofAccessFunc) addr_getFirstname, (QofSetterFunc) addr_setFirstname},
		{ADDR_COMPANY,    QOF_TYPE_STRING, (QofAccessFunc) addr_getCompany,   (QofSetterFunc) addr_setCompany},
		{ADDR_PHONE_ONE,  QOF_TYPE_STRING, (QofAccessFunc) addr_getPhoneOne,  (QofSetterFunc) addr_setPhoneOne},
		{ADDR_PHONE_TWO,  QOF_TYPE_STRING, (QofAccessFunc) addr_getPhoneTwo,  (QofSetterFunc) addr_setPhoneTwo},
		{ADDR_PHONE_THREE, QOF_TYPE_STRING,(QofAccessFunc) addr_getPhoneThree,(QofSetterFunc) addr_setPhoneThree},
		{ADDR_PHONE_FOUR, QOF_TYPE_STRING, (QofAccessFunc) addr_getPhoneFour, (QofSetterFunc) addr_setPhoneFour},
		{ADDR_PHONE_FIVE, QOF_TYPE_STRING, (QofAccessFunc) addr_getPhoneFive, (QofSetterFunc) addr_setPhoneFive},
		{ADDR_ADDRESS,    QOF_TYPE_STRING, (QofAccessFunc) addr_getAddress,   (QofSetterFunc) addr_setAddress},
		{ADDR_CITY,       QOF_TYPE_STRING, (QofAccessFunc) addr_getCity,      (QofSetterFunc) addr_setCity},
		{ADDR_STATE,      QOF_TYPE_STRING, (QofAccessFunc) addr_getState,     (QofSetterFunc) addr_setState},
		{ADDR_ZIP,        QOF_TYPE_STRING, (QofAccessFunc) addr_getZip,       (QofSetterFunc) addr_setZip},
		{ADDR_COUNTRY,    QOF_TYPE_STRING, (QofAccessFunc) addr_getCountry,   (QofSetterFunc) addr_setCountry},
		{ADDR_TITLE,      QOF_TYPE_STRING, (QofAccessFunc) addr_getTitle,     (QofSetterFunc) addr_setTitle},
		{ADDR_CUSTOM_ONE, QOF_TYPE_STRING, (QofAccessFunc) addr_getCustomOne, (QofSetterFunc) addr_setCustomOne},
		{ADDR_CUSTOM_TWO, QOF_TYPE_STRING, (QofAccessFunc) addr_getCustomTwo, (QofSetterFunc) addr_setCustomTwo},
		{ADDR_CUSTOM_THREE, QOF_TYPE_STRING,(QofAccessFunc) addr_getCustomThree,(QofSetterFunc) addr_setCustomThree},
		{ADDR_CUSTOM_FOUR, QOF_TYPE_STRING, (QofAccessFunc) addr_getCustomFour, (QofSetterFunc) addr_setCustomFour},
		{ADDR_NOTE,       QOF_TYPE_STRING, (QofAccessFunc) addr_getNote,      (QofSetterFunc) addr_setNote},
		{ADDR_CATEGORY,   QOF_TYPE_STRING, (QofAccessFunc) addr_getCategory, (QofSetterFunc) addr_setCategory},
		{QOF_PARAM_BOOK,  QOF_ID_BOOK,     (QofAccessFunc) qof_instance_get_book, NULL},
		{QOF_PARAM_GUID,  QOF_TYPE_GUID,   (QofAccessFunc) qof_instance_get_guid, NULL},
		{NULL},
	};

	qof_class_register (PILOT_LINK_QOF_ADDRESS, NULL, params);

	pilot_qof_pack_register ( &address_pack_def);

	return qof_object_register (&address_object_def);
}
