#line 1 "LowHTML.cmod"
/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: LowHTML.cmod,v 1.1 2005/05/11 02:27:20 hww3 Exp $
 */

/*
 * File licensing and authorship information block.
 *
 * Version: MPL 1.1/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Initial Developer of the Original Code is
 *
 * Bill Welliver <hww3@riverweb.com>
 *
 * Portions created by the Initial Developer are Copyright (C) Bill Welliver
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of the LGPL, and not to allow others to use your version
 * of this file under the terms of the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL or the LGPL.
 *
 * Significant Contributors to this file are:
 *
 *
 */

#define THIS_IS_XML2_HTML 1

#include "xml2.h"

/*! @module Public
 */

/*! @module Parser
 */

/*! @module XML2
 */

/*! @class HTML
 */


#undef class_HTML_defined
#define class_HTML_defined
struct program *HTML_program=0;
int HTML_program_fun_num=-1;

#undef var_object_data_HTML_defined
#define var_object_data_HTML_defined

#undef THIS
#define THIS ((struct HTML_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_HTML
#define THIS_HTML ((struct HTML_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_HTML
#define OBJ2_HTML(o) ((struct HTML_struct *)(o->storage+HTML_storage_offset))

#undef GET_HTML_STORAGE
#define GET_HTML_STORAGE ((struct HTML_struct *)(o->storage+HTML_storage_offset)
static ptrdiff_t HTML_storage_offset;
struct HTML_struct {

#ifdef var_object_data_HTML_defined
#line 79 "LowHTML.cmod"
HTML_OBJECT_DATA   *object_data;
#endif /* var_object_data_HTML_defined */
};
#define f_HTML_cq__sprintf_defined
ptrdiff_t f_HTML_cq__sprintf_fun_num = 0;
void f_HTML_cq__sprintf(INT32 args) {
#line 81 "LowHTML.cmod"
INT_TYPE type;
#line 81 "LowHTML.cmod"
struct svalue * t;
#line 81 "LowHTML.cmod"
if(args != 2) wrong_number_of_args_error("_sprintf",args,2);
#line 81 "LowHTML.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("_sprintf",1,"int");
type=Pike_sp[0-2].u.integer;
#line 81 "LowHTML.cmod"
t=Pike_sp+1-2; dmalloc_touch_svalue(Pike_sp+1-2);
{
  push_text("HTML()");
}

}
#define f_HTML_create_defined
ptrdiff_t f_HTML_create_fun_num = 0;
void f_HTML_create(INT32 args) {
#line 86 "LowHTML.cmod"
if(args != 0) wrong_number_of_args_error("create",args,0);
{
}

}
#line 90 "LowHTML.cmod"
int check_html_created()
{
  if(THIS->object_data->ctxt != NULL)
    return 1;
  Pike_error("HTML not initialized.\n");
}


#undef internal_init_HTML_defined
#define internal_init_HTML_defined

#undef HTML_event_handler_defined
#define HTML_event_handler_defined
static void init_HTML_struct(void)
#line 98 "LowHTML.cmod"
{
  HTML_OBJECT_DATA * dta;

  dta = 
	(HTML_OBJECT_DATA*)malloc(sizeof(HTML_OBJECT_DATA));
    if (!dta)
        Pike_error("init_html: Out of memory!\n");

    dta->html = NULL;

    THIS->object_data = dta;
}


#undef internal_exit_HTML_defined
#define internal_exit_HTML_defined

#undef HTML_event_handler_defined
#define HTML_event_handler_defined
static void exit_HTML_struct(void)
#line 112 "LowHTML.cmod"
{ 

    if(THIS->object_data->ctxt != NULL)
      xmlFreeParserCtxt(THIS->object_data->ctxt);

   if(THIS->object_data)
  {
    free(THIS->object_data);
  }
}

#ifdef HTML_event_handler_defined
static void HTML_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_HTML_defined
  case PROG_EVENT_INIT: init_HTML_struct(); break;

#endif /* internal_init_HTML_defined */

#ifdef internal_exit_HTML_defined
  case PROG_EVENT_EXIT: exit_HTML_struct(); break;

#endif /* internal_exit_HTML_defined */
  default: break; 
  }
}

#endif /* HTML_event_handler_defined */
/*! @endclass
 */


/*! @endmodule
 */

/*! @endmodule
 */

/*! @endmodule
 */


#line 137 "LowHTML.cmod"
void pike_init_xml2_html()
{
  
#ifdef class_HTML_defined

#ifdef PROG_HTML_ID
  START_NEW_PROGRAM_ID(HTML);
#else
  start_new_program();

#endif /* PROG_HTML_ID */

#ifndef tObjImpl_HTML

#undef tObjImpl_HTML
#define tObjImpl_HTML tObj

#endif /* tObjImpl_HTML */

#ifdef THIS_HTML

  HTML_storage_offset=ADD_STORAGE(struct HTML_struct);

#endif /* THIS_HTML */

#ifdef HTML_event_handler_defined
  pike_set_prog_event_callback(HTML_event_handler);

#endif /* HTML_event_handler_defined */

#ifdef f_HTML_cq__sprintf_defined
#line 81 "LowHTML.cmod"
  f_HTML_cq__sprintf_fun_num =
    ADD_FUNCTION2("_sprintf", f_HTML_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tMix,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_HTML_cq__sprintf_defined */

#ifdef f_HTML_create_defined
#line 86 "LowHTML.cmod"
  f_HTML_create_fun_num =
    ADD_FUNCTION2("create", f_HTML_create, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_HTML_create_defined */
  HTML_program=end_program();
  HTML_program_fun_num=add_program_constant("HTML",HTML_program,0);

#endif /* class_HTML_defined */
#line 140 "LowHTML.cmod"
}

void pike_exit_xml2_html()
{
  
#ifdef class_HTML_defined
  if(HTML_program) {
    free_program(HTML_program);
    HTML_program=0;
  }

#endif /* class_HTML_defined */
#line 145 "LowHTML.cmod"
}

